<?php
namespace Txd\FieldTypes;


class Autosuggest extends Select {

    public $asInput = false;

    public function __construct($nome, $etichetta = "", $classi_html = []){
        parent::__construct($nome,$etichetta, $classi_html);
    }

    public function init_tipo(){
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }
        //$this->add_classe_html("txd_autosuggest");
    }
    
    public function parse_valore($valore) {
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }
        $processed = parent::parse_valore($valore);
        if($processed === "" && $this->allowNoMatch){
            $processed = $valore;
        }
        
        return $processed;
    }

    /**
     * abilita la stampa del campo base dell'autosuggest come input
     * @param bool $value default true
     * 
     * @return $this
     */
    public function optAsInput($value = true){
        $this->asInput = $value;
        return $this;
    }

    /**
     * disabilita la stampa dell'attributo name nel campo generato dall'autosuggest
     * 
     * @param bool $value
     * 
     * @return $this
     */
    public function optNoName($value = false){
        $this->set_html_attribute("data-no-name",$value);
        return $this;
    }

    /**
     * permette l'inserimento di valori non presenti nella lista sorgente. Forza la stampa come input
     * @param bool $value
     * 
     * @return $this
     */
    public function optAllowNoMatch($value = false){
        $this->allowNoMatch = $value;
        $this->set_html_attribute("data-allow-no-match",$this->allowNoMatch);
        return $this;
    }

    public $allowNoMatch = false;

    /**
     * mostra sempre l'intera lista, portando in alto i match
     * @param bool $value
     * 
     * @return $this
     */
    public function optShowAll($value = false){        
        $this->set_html_attribute("data-show-all",$value);
        return $this;
    }

    /**
     * Sella la larghezza della tendina in px. default a "auto", adatta la larghezza al  contenuto
     * 
     * @param string $value
     * 
     * @return $this
     */
    public function optWidth($value = "auto"){
        $this->set_html_attribute("data-width",$value);
        return $this;
    }

    /**
     * setta l'altezza massima della tendina in px. default a 254
     * @param int $value
     * 
     * @return $this
     */
    public function optMaxHeight($value = 254){
        $this->set_html_attribute("data-max-height",$value);
        return $this;
    }

    /**
     * setta dopo quanti caratteri mostrare la tendina. default a 0 (tendina mostrata immediatamente)
     * @param $value
     * 
     * @return $this
     */
    public function optMinChars($value = 0){
        $this->set_html_attribute("data-min-chars",$value);
        return $this;
    }

    public function build_edit(){
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }
        
        if($this->asInput || $this->allowNoMatch){
            $this->add_html_attribute("data-objects",json_encode($this->opzioni_select()));
        }
        return view("txd::FieldTypes.Autosuggest",["campo_obj"=>$this]);
    }

}