<?php

namespace Txd;

use Exception;

class txdFields implements \IteratorAggregate {
	
    protected $item_obj_list = [];
    protected $current_model_obj;

    use Traits\addTypes;
    
    

    private static $legacyTypesConversion = [
        "text" => FieldTypes\Text::class,
        "data" => FieldTypes\Date::class,
        "datatime" => FieldTypes\Datetime::class,
        "valuta" => FieldTypes\Valuta::class,
        "select" => FieldTypes\Select::class,
        "select_linked" => FieldTypes\SelectLinked::class,
        "txdJson" => FieldTypes\TxdJson::class,
        "email" => FieldTypes\Email::class,
        "password" => FieldTypes\Password::class,
        "number" => FieldTypes\Number::class,
        "checkbox" => FieldTypes\LegacyCheckbox::class,
        "textarea" => FieldTypes\Textarea::class,
        "html" => FieldTypes\Html::class,
        "radio" => FieldTypes\Radio::class,
        "hidden" => FieldTypes\Hidden::class,
        "parse_value" => FieldTypes\ParseValue::class,
        "custom_macro" => FieldTypes\CustomMacro::class,
        "file" => FieldTypes\File::class,
        "solo_testo" => FieldTypes\SoloTesto::class,

    ];

	public function __construct($current_model_obj){
		$this->current_model_obj = $current_model_obj;
	}
    
    public function getIterator() {
		return new \ArrayIterator($this->item_obj_list);
    }

    /**
     * aggiunge un attributo all'elenco
     * 
     * @param string $nome nome del campo su DB
     * @param string $tipo tipo di attributo. accetta il nome di una classe in Txd\FieldTypes, una classe custom o uno dei tipi legacy (text, email, password, data, select, etc...)
     * @param string $etichetta [default: ""] eventuale etichetta da stampare
     * @param array $classi_html elenco di classi da passare al campo
     * 
     * @return txdAttributes
     */
    
    public function add($nome,$typeName = "Txd\FieldTypes\Text", $etichetta = "", $classi_html = []){
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }
        
        $class = "Txd\FieldTypes\\".$typeName;
        if(!class_exists($class)){
            $class = $typeName;
            if(!class_exists($class)){
                if(isset(txdFields::$legacyTypesConversion[$class])){
                    $class = txdFields::$legacyTypesConversion[$class];
                }else{
                    if(config("app.debug",false)){
                        throw new Exception(__METHOD__." - FieldType '".$typeName."' is not a known php class nor a legacy type");
                    }else{
                        \Log::warning(__METHOD__." - FieldType '".$typeName."' is not a known php class nor a legacy type. '".Text::class."' used instead");
                        $class = Text::class;
                    }
                }
                
            }
        }
        
        $tmp = new $class($nome, $etichetta, $classi_html);
        
        $tmp->set_current_model_obj($this->current_model_obj);
        $this->item_obj_list[$nome] = $tmp;

        $tmp->parse_model_rules();

        return $tmp;
    }

    /**
     * ritorna il campo passato (o i campi passati, in caso di array) come parametro se presente, NULL altrimenti
     * 
     * @return mixed txdAttributes|NULL
     */
    public function retrieve($nome_campo){
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }
        if(is_array($nome_campo)){
            return array_map(function($el){return $this->retrieve($el);},$nome_campo);
        }
        return $this->item_obj_list[$nome_campo] ?? null;
    }

    /**
     * imposta il modello di partenza all'interno del campo corrente
     * 
     * @param object $obj
     */
    public function set_current_model_obj($obj){
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }
        $this->current_model_obj = $obj;
    }

    /**
     * invoca il metodo inizializzaCampi del modello su cui sono stati costruiti gli attributi
     * in modo che siano disponibili nell'array db_fields del modello
     * 
     * @return array item_obj_list
     */
    public function build(){
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }

        foreach($this->item_obj_list as $obj){
            $obj->finalizza_info();
        }
        
        $this->current_model_obj->set_db_fields($this);
        $this->current_model_obj->inizializzaCampi();
    }

    public function __call($name, $args) {
        return self::methodDispatcher($this, $name, $args);
    }

    private static $methodTable = array();

    public static function methodDispatcher( 
            $instance, $name, $args) {
        $table =& self::$methodTable;        
        $class = get_class($instance);
        do {
            if (array_key_exists($class, $table) 
                    && array_key_exists($name, $table[$class]))
                break;

            $class = get_parent_class($class);
        } while ($class !== false);

        if ($class === false)
            throw new \Exception("Method not found");

        $func = $table[$class][$name];
        array_unshift($args, $instance);

        return call_user_func_array($func, $args);
    }

    public static function injectAddMethod($methodName, $method) {

        $class = get_called_class();        
        $table =& self::$methodTable;
        if (!array_key_exists($class, $table))        
            $table[$class] = array();                

        $table[$class][$methodName] = $method;
    }
}