<?php

namespace Txd\Traits;

use Txd\txdAttributes;
use Txd\txdFields;

trait txdModel {
    
    /**
     * se impostato a TRUE chiama il metodo init_db_fields direttamente nel costruttore (cosi' che siano disponibili fin da subito fillable e simili)
     * 
     * @var boolean
     */
    public static $AUTO_LOAD_DB_FIELDS = false;
    

    protected $db_fields = null;
    /**
     * abilita la costruzione del nome campo complesso
     *
     * @var boolean
     */
    public $txdPrefixEnable = false;
    /**
     * popola l'elenco degli attributi legati al database
     * 
     * [placeholder da sostituire con i campi che verranno poi stampati nel form]
     * 
     */

	public function init_db_fields() {

        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }

        if(is_null($this->db_fields)){
            $db_fields = new txdFields($this);
            
            
            /** ESEMPIO */
            // $db_fields->add("nome")->add_settore("anagrafica")->add_rule("required");
            // $db_fields->add("cognome")->add_settore("anagrafica");

            $db_fields->build();
        }
    }
    
    /**
     * imposta l'attributo locale db_fields
     * 
     * @param txdFields $txdField
     */
    public function set_db_fields(txdFields $txdField){
        $this->db_fields = $txdField;
    }
    

    /**
     * ritorna un txdAttribute o txdFields (con tutti gli attribute) a seconda del parametro ricevuto
     * inizializa db_fields se e' la prima volta
     * 
     * @param mixed $info NULL|string
     * @return txdFields|txdAttributes
     */
    public function fields($info = null){
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }

        $this->init_db_fields(); //cosi' che venga sempre popolato l'array anche se non fosse ancora stato chiamato

        if(is_string($info) && strlen($info) > 0){
            $out = $this->db_fields->retrieve($info);
        }else{
            $out = $this->db_fields;
        }

        return $out;
    }
    
    /**
     * recupera tutti i campi di un determinato settore (o tutti in caso di NULL come parametro)
     * 
     * @param string $settori,... nome del settore o array vuoto per tutti i settori
     * @return array elenco degli attributi del settore richiesto
     */
	public function get_campi(...$settori) {

        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }

        $this->init_db_fields(); //cosi' che venga sempre popolato l'array anche se non fosse ancora stato chiamato
        
		if(empty($settori)){
			return $this->db_fields;
		}else{
			$arr_temp = array();

			foreach ($this->db_fields as $campo){
				if(!empty(array_intersect($settori,$campo->settore))){
					$arr_temp[] = $campo;
				}
			}
			return $arr_temp;
		}
	}
	
    
    /**
     * da invocare dopo aver definito i campi: va a settare regole, fillable, types, etc. sulla base di quanto definito
     * 
     */
	public function inizializzaCampi(...$settori) {
        
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }
        
        foreach ($this->get_campi(...$settori) as $campo){

            // $campo->set_current_model_obj($this); /** non dovrebbe piu' servire perche' l'abbiamo aggiunto al metodo add di txdAttributes */

			if(!$campo->skip_check_fillable){
				if($campo->isFillable()){
					$this->add_fillable($campo->nome_campo);
				}else{
					$this->remove_fillable($campo->nome_campo);
				}
            }
            
            if($campo->isHtml()){
                $this->add_html_field($campo->nome_campo);
            }else{
                $this->remove_html_field($campo->nome_campo);
            }
            
            // ddd($campo->model_rules);
            if(count($campo->get_model_rules())>0){
				$this->rules[$campo->nome_campo] = join("|", $campo->get_model_rules());
            }
            
            //andiamo a processare eventuali tipi ad hoc (per la conversione dei valori in fase di salvataggio)
            if($campo->get_model_type() !== null){
                $this->types[$campo->nome_campo] = $campo->get_model_type();
            }
		}
	}


	public function remove_fillable($param) {
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }

		$indice = array_search($param, $this->fillable, true);
		if($indice!==false){
			unset($this->fillable[$indice]);
		}
	}
	
	public function add_fillable($param) {
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }
		$this->fillable[] = $param;
	}

}