<?php

namespace Txd\Traits;

trait VirtualAttributesValidationTrait {
    public function getModelAttributes()
    {
        try{
            $attrs = parent::getModelAttributes();
        }catch(\Throwable $e){
            $attrs = [];
        }
        
        $missing_attrs = array_filter(array_keys($this->rules),function($el)use($attrs){
            return !array_key_exists($el,$attrs);
        });

        foreach($missing_attrs as $attr){
            if(request()->has($attr)){
                $attrs[$attr] = $this->$attr;
            }
        }

        return $attrs;
    }
}