<?php

namespace Txd\FieldTypes\DynamicAttributes;

use Txd\txdAttributes;
use Txd\txdFields;


class AttributesSet implements \IteratorAggregate,\ArrayAccess {
    protected $attributes=[];
    public $attribute_field_name;
    public $attribute_field_label;
    public $attribute_field_type;
    public $attribute_field_required;
    public $attribute_field_select_options;
    // implementazione arrayAccess e IteratorAggregate
    // funzioni per usare un oggetto txdFields come un array. tutti questi metodi funzionano solo sul settore "default"
    public function offsetSet($offset, $value) {
        if (is_null($offset)) {
            $this->attributes[] = $value;
        } else {
            $this->attributes[$offset] = $value;
        }
    }

    /**
     * @param mixed $offset
     * 
     * @return bool
     */
    public function offsetExists($offset) {
        return isset($this->attributes[$offset]);
    }

    public function offsetUnset($offset) {
        unset($this->attributes[$offset]);
    }

    /**
     * @param mixed $offset
     * 
     * @return DynamicAttribute
     */
    public function offsetGet($offset) {
        return isset($this->attributes[$offset]) ? $this->attributes[$offset] : null;
    }

    
    /**
     * @return ArrayIterator|DynamicAttribute[]
     */
    public function getIterator() {
		return new \ArrayIterator($this->attributes);
    }

    
    // fine implementazione ArrayAccess e IteratorAggregate

    public function __construct($attributes, $attribute_field_name = "name",$attribute_field_label = null, $attribute_field_type = "type")
    {
        $this->attribute_field_name = is_callable($attribute_field_name)?$attribute_field_name:function($attribute) use ($attribute_field_name){ return $attribute->$attribute_field_name; };

        $attribute_field_label = $attribute_field_label ?? function(){return null;};
        $this->attribute_field_label = is_callable($attribute_field_label)?$attribute_field_label:function($attribute) use ($attribute_field_label){ return $attribute->$attribute_field_label; };

        $this->attribute_field_type = is_callable($attribute_field_type)?$attribute_field_type:function($attribute) use ($attribute_field_type){ return $attribute->$attribute_field_type; }; 

        foreach($attributes as $attribute){
            $raw_type = ($this->attribute_field_type)($attribute);
            $this->attributes[] = new DynamicAttribute([
                "name" => ($this->attribute_field_name)($attribute),
                "label" => ($this->attribute_field_label)($attribute),
                "type" => txdFields::findClass($raw_type),
                "original_obj" => $attribute,

            ]);
        }
    }

    public function map(callable $callback){
        return array_map($callback,$this->attributes);
    }

}