<?php

namespace Txd\Provider;

use Illuminate\Support\ServiceProvider;
use Txd\txdFields;

/**
 *  *
 * @author Fabio Spadea <fabio@techseed.it>
 */
class FieldTypesServiceProvider extends ServiceProvider
{

    /**
     * Boot the service provider.
     *
     * @return void
     */
    public function boot()
    {   
        $this->publishes([
			__DIR__.'/config/txd_fieldtypes.php' => config_path('txd_fieldtypes.php'),
		], "txd_fieldtypes:config");

        $this->publishes([
			__DIR__.'/../views/FieldTypes' => base_path('resources/views/vendor/txd/FieldTypes'),
        ], "txd_fieldtypes:views");
        
        $this->publishes([
			__DIR__.'/../assets/js' => base_path('public/plugins/JSM_layout'),
		], "txd_js_libraries:all");
        $this->publishes([
			__DIR__.'/../assets/js/txd-autosuggest' => base_path('public/plugins/JSM_layout/txd-autosuggest'),
		], "txd_js_libraries:autosuggest");
        $this->publishes([
			__DIR__.'/../assets/js/txd-multiselect' => base_path('public/plugins/JSM_layout/txd-multiselect'),
		], "txd_js_libraries:multiselect");
        $this->publishes([
			__DIR__.'/../assets/js/txd-datepicker' => base_path('public/plugins/JSM_layout/txd-datepicker'),
		], "txd_js_libraries:datepicker");


        $this->mergeConfigFrom(
			__DIR__.'/../config/txd_fieldtypes.php', 'txd_fieldtypes'
		);

        //caricamento namespace per view
		$this->loadViewsFrom(base_path('resources/views/vendor/txd'), 'txd');
		$this->loadViewsFrom(__DIR__.'/../views', 'txd');
    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        self::registerDbFields($this->app);
    }

    public static function registerDbFields(\Illuminate\Foundation\Application $app = null){
        if(is_null($app)){
            $app = app();
        }
        $app->alias("dbFields",txdFields::class);

        $app->bind("dbFields",function(){
            return new txdFields(null,true);
        });
    }

}
