<?php

namespace Txd\Traits;

use Txd\txdAttributes;
use Txd\txdFields;


trait txdModel {
    
    /**
     * se impostato a TRUE chiama il metodo init_db_fields direttamente nel costruttore (cosi' che siano disponibili fin da subito fillable e simili)
     * 
     * @var boolean
     */
    public static $AUTO_LOAD_DB_FIELDS = false;
    

    protected $db_fields = null;
    /**
     * abilita la costruzione del nome campo complesso
     *
     * @var boolean
     */
    public $txdPrefixEnable = false;
    /**
     * Experimental: flag per abilitare il caching dei campi
     * @var bool
     */
    public $cache_enabled = false;
    /**
     * popola l'elenco degli attributi legati al database
     * 
     * [placeholder da sostituire con i campi che verranno poi stampati nel form]
     * 
     */

	public function init_db_fields() {

        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }

        if(is_null($this->db_fields)){
            $db_fields = $this->cache_enabled ?cache('db_fields.'.static::class):null;
            if(is_null($db_fields)){
                $db_fields = new txdFields($this);
                $this->set_db_fields($db_fields);
                $current = resolve("dbFields");
                
                app()->instance("dbFields",$db_fields);
                
                $this->db_fields_definition($db_fields);
                $db_fields->sort();
                if($current->throwaway){
                    \Txd\Provider\FieldTypesServiceProvider::registerDbFields();
                }else{
                    app()->instance("dbFields",$current);
                    
                }
                $this->cache_enabled ?cache(['db_fields.'.static::class=>$db_fields],now()->addSeconds(30)):"";
            }else{
                $this->set_db_fields($db_fields);
            }
            
            $db_fields->build();
        }
    }
    
    /**
     * imposta l'attributo locale db_fields
     * 
     * @param txdFields $txdField
     */
    public function set_db_fields(txdFields $txdField){
        $this->db_fields = $txdField;
    }

    /**
     * funzione per isolamento configurazione db_fields da codice boilerplate.
     * deve essere ridefinita nel modello. Se nel modello è stata ridefinita init_db_fields classico questo metodo non viene invocato
     * 
     * @param \Txd\txdFields $db_fields elemento da configurare
     * 
     * @return void
     */
    public function db_fields_definition($db_fields){

    }
    

    /**
     * ritorna un txdAttribute o txdFields (con tutti gli attribute) a seconda del parametro ricevuto
     * inizializa db_fields se e' la prima volta
     * 
     * @param string|null $fieldName settore da recuperare
     * * @param string|null $sector settore di origine
     * @return txdFields|txdAttributes
     */
    
    public function fields(string $fieldName = null,string $sector = null){
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }

        $this->init_db_fields(); //cosi' che venga sempre popolato l'array anche se non fosse ancora stato chiamato

        if(is_string($fieldName) && strlen($fieldName) > 0){
            $out = $this->db_fields->retrieve($fieldName, $sector);
        }else{
            $out = $this->db_fields;
        }

        return $out;
    }
    
    /**
     * recupera tutti i campi di un determinato settore (o tutti in caso di NULL come parametro)
     * 
     * @param array|string $settori,... nome del settore o array vuoto per tutti i settori
     * @return \Txd\txdFields elenco degli attributi del settore richiesto
     */
	public function get_campi($settori = []) {
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }

        if(is_string($settori)) $settori = [$settori];
        $this->init_db_fields(); //cosi' che venga sempre popolato l'array anche se non fosse ancora stato chiamato
        $new = $this->db_fields->reduce($settori);
        $new->source = $settori;
        return $new;
		
	}

    /**
     * ritorna un oggetto \Txd\txdFields con campi inizializzati secondo i settori passati, agganciato ad una entità nuova (new)
     * @param array|string $settori
     * 
     * @return \Txd\txdFields
     */
    public static function get_campi_statici($settori = []) {

        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }
        if(is_string($settori)) $settori = [$settori];
        $obj = new static();
        $obj->init_db_fields(); //cosi' che venga sempre popolato l'array anche se non fosse ancora stato chiamato
        return $obj->get_campi($settori);
		
	}
	
    
    /**
     * da invocare dopo aver definito i campi: va a settare regole, fillable, types, etc. sulla base di quanto definito
     * 
     */
	public function inizializzaCampi($settori = []) {
        
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }
        
        if(is_string($settori)) $settori = [$settori];
        


        foreach ($this->get_campi($settori) as $campo){

            // $campo->set_current_model_obj($this); /** non dovrebbe piu' servire perche' l'abbiamo aggiunto al metodo add di txdAttributes */

			if(!$campo->skip_check_fillable){
				if($campo->isFillable()){
					$this->add_fillable($campo->nome_campo);
				}else{
					$this->remove_fillable($campo->nome_campo);
				}
            }
            
            if($campo->isHtml()){
                $this->add_html_field($campo->nome_campo);
            }else{
                $this->remove_html_field($campo->nome_campo);
            }
            
            // ddd($campo->model_rules);
            if(count($campo->get_model_rules())>0){
                $attribute_rules = $campo->get_model_rules();
                //convert | to array
                $attribute_rules = array_map(function($rule){ return is_string($rule)?explode("|",$rule):$rule;},$attribute_rules);
                // flatten resulting array
				$this->rules[$campo->nome_campo] =  array_flatten($attribute_rules);
            }
            
            //andiamo a processare eventuali tipi ad hoc (per la conversione dei valori in fase di salvataggio)
            if($campo->get_model_type() !== null){
                $this->types[$campo->nome_campo] = $campo->get_model_type();
            }
		}
	}


	
	/**
     * rimuove un attributo dalla lista dei fillable
	 * @param string $param
	 * 
	 * @return void
	 */
	public function remove_fillable(string $param) {
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }

		$indice = array_search($param, $this->fillable, true);
		if($indice!==false){
			unset($this->fillable[$indice]);
		}
	}
	
	/**
     * aggiunge un attributo alla lista dei fillable
	 * @param string $param
	 * 
	 * @return void
	 */
	public function add_fillable(string $param) {
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }
		$this->fillable[] = $param;
	}

}