<?php

namespace Txd\Traits\FieldTypes;

use Txd\FieldTypes\Enums\TXD_ATTRIBUTES_BUILD_MODE;
use Opis\Closure\SerializableClosure;
trait DrawableFieldTrait {
    public abstract function get_valore($raw = false);

    protected $custom_build_view = null;
    protected $view_is_cell = false;
    protected $custom_build_edit = null;
    
    public $hide_in_view_form = false;
    public $hide_in_edit_form = false;
    public $field_build_mode = TXD_ATTRIBUTES_BUILD_MODE::VIEW_AND_EDIT;
    /**
     * Genera l'HTML della modalità view del campo
     *
     * @return string
     */
    public function render_view(){
        if(!is_null($this->custom_build_view)){
            if($this->view_is_cell){
                return ($this->custom_build_view)($this->get_valore(),$this->current_model_obj);
            }else{
                return ($this->custom_build_view)($this);
            }
        }
        return $this->build_view();
    }
        
    /**
     * Genera l'HTML della modalità view del campo
     *
     * @return string
     */
    public function build_view(){
        return e($this->get_valore());
    }
    
    public function custom_build_view(\Closure $viewBuilder){
        $this->custom_build_view = new SerializableClosure($viewBuilder);
        $this->view_is_cell = false;
    }

    
    /**
     * @param callable $cellView 
     *  signature: function($v,$r):string
     * 
     * accepts the field value ($v) and the model ($r). returns an HTML string
     * 
     * @return $this
     */
    public function cell(\Closure $cellView){
        $this->custom_build_view($cellView);
        $this->view_is_cell = true;
        return $this;
    }

    public function render_edit(){
        if(!is_null($this->custom_build_edit)){
            return ($this->custom_build_edit)();
        }
        return $this->build_edit();
    }
    /**
     * Genera l'HTML della modalità edit del campo
     *
     * @return string
     */
    public function build_edit(){
        return "Error: Missing type";
    }

    public function custom_build_edit(callable $viewBuilder){
        $this->custom_build_edit = new SerializableClosure(function() use ($viewBuilder){return $viewBuilder($this);});
    }


    /**
     * Se impostato a true nasconde il campo (inclusa la label) dal form di edit
     * If true, the field will not be displayed in an edit form
     * 
     * @param bool $enable
     * 
     * @return $this
     */
    public function hide_from_edit(bool $enable = true){
        $this->hide_in_edit_form = $enable;
        return $this;
    }

    /**
     * Se impostato a true nasconde il campo (inclusa la label) dal form di view
     * If true, the field will not be displayed in an view form
     * 
     * @param bool $enable
     * 
     * @return $this
     */
    public function hide_from_view(bool $enable = true){
        $this->hide_in_view_form = $enable;
        return $this;
    }

    /**
     * Definisce la modalità di costruzione del campo nei form di view ed edit. 
     * I valori possibili sono TXD_ATTRIBUTES_BUILD_MODE::VIEW_AND_EDIT, TXD_ATTRIBUTES_BUILD_MODE::VIEW_ONLY, TXD_ATTRIBUTES_BUILD_MODE::EDIT_ONLY</b> 
     * 
     * @param bool $txd_attribute_build_mode_flag
     * 
     * @return $this
     */

    public function set_build_mode(int $txd_attribute_build_mode_flag = 0){
        if(in_array($txd_attribute_build_mode_flag,[0,1,2])){
            $this->field_build_mode = $txd_attribute_build_mode_flag;
        }else{
            $this->field_build_mode = 0;
        }
        return $this;
    }







}