/** 
 *   txdAutoSuggest
 *   @author sabba <francesco@techseed.it>
 *   @version 1.1.0.0
 *   derived by
 *	jQuery autoComplete v1.0.7
 *   Copyright (c) 2014 Simon Steinberger / Pixabay
 *   GitHub: https://github.com/Pixabay/jQuery-autoComplete
 *	License: http://www.opensource.org/licenses/mit-license.php
 */

// opzioni campo autosuggest (inserire come attributi)

// data-no-name  (stringa true/false): rimuovi l'attributo name dal campo autosuggest (rimuove da sottomissione form)
// data-allow-no-match  (stringa true/false): permetti l'inserimento di valori non presenti nella lista di origine
// data-no-submit  (stringa true/false): disabilita/abilita la sottomissione del form parent
// data-show-all (stringa true/false): mostra sempre l'intera lista, portando in alto i match
// data-width (intero, >=0 o stringa "auto" (default 0 => inherit)): setta la larghezza della tendina a n px. in caso di n = auto, adatta automaticamente la larghezza della tendina al contenuto. 
//            Di default la larghezza è ancorata alla larghezza dell'input
// data-max-height (intero, >0, default 254 (px)): setta l'altezza della tendina a n px. Di default n = 254 px
// data-min-chars (intero, >0): setta il numero minimo di caratteri per iniziare l'autosuggest a n (accetta solo interi positivi o 0)
// data-objects (array chiave valore json encoded): permette di inizializzare la lista delle opzioni in caso di input
//
//
// per assegnare un placeholder ad un input generato da un campo select, assegnare l'attributo 'placeholder' al select
//
//////////////////////////////////////////////////////////////////////////////////////////////////
var elenco_source_autocomplete = {};

(function ($) {
    
    function txdAutoSuggest($el, options) {
        var that = this;
        this.options = options;
        this.$el = $el;
        //campo del form. Può essere o l'input stesso o il select nascosto
        this.$input = $el;


        // sc = 'suggestions container'
        this.$dropdown = $('<div class="txdAutoSuggest-suggestions ' + this.options.menuClass + '"></div>');
        this.$dropdown.css("max-height", parseInt(this.options.maxHeight).toString() + "px");
        if (that.options.width == "auto") {
            this.$dropdown.css("width", "auto");
        } else if (parseInt(this.options.width) > 0) {
            this.$dropdown.css("width", parseInt(this.options.width).toString() + "px");
        }
        this.cache = {};
        this.last_val = '';
        this.idx_source = this.$el.attr("idx_source");
    }

    txdAutoSuggest.prototype = {
        constructor: txdAutoSuggest,

        init: function () {
            var that = this;
            that.prepareInput();
            that.$el.data('txdAutoSuggest',that.$input.data('txdAutoSuggest'));
            that.$input.removeData('txdAutoSuggest');
            that.events();
        },
        prepareInput: function () {
            var that = this;

            if (that.$el.is("input") && that.$el[0].hasAttribute("rif_campo_name")) {
                that.$input = $("input[name=" + that.$el.attr("rif_campo_name") + "]").first();
            } else {
                var new_input = $("<input />");
                $element = that.$input;
                for (var i in $element[0].classList) {
                    if ($element[0].classList.hasOwnProperty(i)) {
                        new_input.addClass($element[0].classList[i]);
                    }
                }
                $element.addClass("txd_autosuggest_processed");
                if ($element.is("select")) {
                    var MyArray = $element.find("option").map(function (idx, el) {
                        return {
                            id: $(el).attr("value"),
                            value: $(el).text()
                        };
                    }).toArray();

                    if(!that.idx_source) that.idx_source = "select_autogen_" + $element.attr("name");
                    if(MyArray.length>0) elenco_source_autocomplete[that.idx_source] = MyArray;
                }else if($element[0].hasAttribute("data-objects")){
                    let elements =JSON.parse($element.attr("data-objects"));
                    
                    var MyArray = Object.keys(elements).map(function (el) {
                        return {
                            id: el,
                            value: elements[el]
                        };
                    });

                    if(!that.idx_source) that.idx_source = "select_autogen_" + $element.attr("name");
                    if(MyArray.length>0) elenco_source_autocomplete[that.idx_source] = MyArray;
                }


                new_input.attr("idx_source", that.idx_source);
                new_input.attr("style", $element.attr("style"));
                if(that.options.noName){
                    new_input.removeAttr("name");
                }else{
                    new_input.attr("name", $element.attr("name") + "_autosuggest");
                }
                new_input.attr("placeholder", $element.attr("placeholder"));

                var obj = that.findIdInSource(that.idx_source, that.$input.val())
                if (obj) {
                    new_input.val(obj.value);
                    new_input.attr('value',obj.value);
                }else if(that.options.allowNoMatch){
                    new_input.val($element.val());
                    new_input.attr('value',$element.val());
                    that.$input.val(new_input.val());
                }

                that.$el = new_input;

                $element.before(that.$el);
                $element.hide();
            }
            that.$el.closest("form").attr("autocomplete","off");
        },
        events: function () {
            var that = this;
            $(window).on('resize.txdAutoSuggest', that.updateSC);

            that.$dropdown.appendTo('body');

            that.$dropdown.on('mouseleave', '.txdAutoSuggest-suggestion', function () {
                $('.txdAutoSuggest-suggestion.selected').removeClass('selected');
            });

            that.$dropdown.on('mouseenter', '.txdAutoSuggest-suggestion', function () {
                $('.txdAutoSuggest-suggestion.selected').removeClass('selected');
                $(this).addClass('selected');
            });

            that.$dropdown.on('mousedown click', '.txdAutoSuggest-suggestion', function (e) {
                var item = $(this),
                    v = item.data('val');
                if (v || item.hasClass('txdAutoSuggest-suggestion')) { // else outside click
                    that.onSelect(e, v, item);
                    that.$dropdown.hide();
                }
                return false;
            });

            that.$el.on('blur.txdAutoSuggest', function () {
                that.singleMatch();
                try {
                    over_sb = $('.txdAutoSuggest-suggestions:hover').length;
                } catch (e) {
                    over_sb = 0;
                } // IE7 fix :hover
                if (!over_sb) {
                    that.last_val = that.$el.val(); //TO_CHECK
                    that.$dropdown.hide();
                    setTimeout(function () {
                        that.$dropdown.hide();
                    }, 350); // hide suggestions on fast input
                } else if (!that.$el.is(':focus')) setTimeout(function () {
                    that.$el.focus();
                }, 20);
            });

            //that.$el.on('change.txdAutoSuggest', function(){that.singleMatch()});

            if (!that.options.minChars) that.$el.on('focus.txdAutoSuggest', function () {
                that.last_val = '\n';
                that.$el.trigger('keyup.txdAutoSuggest');
            });

            that.$el.on('keydown.txdAutoSuggest', function (e) {
                // down (40), up (38)
                if ((e.which == 40 || e.which == 38) && that.$dropdown.html()) {
                    var next, sel = $('.txdAutoSuggest-suggestion.selected', that.$dropdown);
                    if (!sel.length) {
                        next = (e.which == 40) ? $('.txdAutoSuggest-suggestion', that.$dropdown).first() : $('.txdAutoSuggest-suggestion', that.$dropdown).last();
                        that.$el.val(next.addClass('selected').data('val'));
                    } else {
                        next = (e.which == 40) ? sel.next('.txdAutoSuggest-suggestion') : sel.prev('.txdAutoSuggest-suggestion');
                        if (next.length) {
                            sel.removeClass('selected');
                            that.$el.val(next.addClass('selected').data('val'));
                        } else {
                            sel.removeClass('selected');
                            that.$el.val(that.last_val);
                            next = 0;
                        }
                    }
                    that.updateSC(0, next);
                    return false;
                }
                // esc
                else if (e.which == 27){
                     that.$el.val(that.last_val)
                     that.$dropdown.hide();
                }
                // enter or tab
                else if (e.which == 13 || e.which == 9) {
                    
                    var sel = $('.txdAutoSuggest-suggestion.selected', that.$dropdown);
                    
                    if (sel.length && that.$dropdown.is(':visible')) {
                        that.onSelect(e, sel.data('val'), sel);
                        setTimeout(function () {
                            that.$dropdown.hide();
                        }, 20);
                    }else{
                        that.singleMatch();
                    }
                    
                    if (e.which == 13) {
                        e.preventDefault();
                        if(!that.options.noSubmit){
                            var form = that.$el.closest("form");
                            if (form.length == 1) {
                                form.submit();
                            }
                        }
                    }
                }
            });

            that.$el.on('keyup.txdAutoSuggest', function (e) {
                if (!~$.inArray(e.which, [13, 27, 35, 36, 37, 38, 39, 40])) {
                    var val = that.$el.val();
                    if (val.length >= that.options.minChars) {
                        if (val != that.last_val) {
                            that.last_val = val;
                            clearTimeout(that.timer);
                            if (that.options.cache) {
                                if (val in that.cache) {
                                    that.suggest(that.cache[val]);
                                    return;
                                }
                                // no requests if previous suggestions were empty
                                for (var i = 1; i < val.length - that.options.minChars; i++) {
                                    var part = val.slice(0, val.length - i);
                                    if (part in that.cache && !that.cache[part].length) {
                                        that.suggest([]);
                                        return;
                                    }
                                }
                            }
                            that.timer = setTimeout(function () {
                                that.source(val)
                            }, that.options.delay);
                        }
                    } else {
                        that.last_val = val;
                        that.$dropdown.hide();
                    }
                }
            });
        },
        updateSC: function (resize, next) {
            var that = this;
            let body = $("body");
            that.$dropdown.css({
                top: -body.offset().top+that.$el.offset().top + that.$el.outerHeight() + that.options.verticalOffset,
                left: -body.offset().left+that.$el.offset().left,
            });
            if(this.options.width === 0){
                that.$dropdown.css('width',this.$el.outerWidth());
            }
            if (!resize) {
                that.$dropdown.show();
                if (!that.$dropdown.maxHeight) that.$dropdown.maxHeight = parseInt(that.$dropdown.css('max-height'));
                if (!that.$dropdown.suggestionHeight) that.$dropdown.suggestionHeight = $('.txdAutoSuggest-suggestion', that.$dropdown).first().outerHeight();
                if (that.$dropdown.suggestionHeight)
                    if (!next) that.$dropdown.scrollTop(0);
                    else {
                        var scrTop = that.$dropdown.scrollTop(),
                            selTop = next.offset().top - that.$dropdown.offset().top;
                        if (selTop + that.$dropdown.suggestionHeight - that.$dropdown.maxHeight > 0)
                            that.$dropdown.scrollTop(selTop + that.$dropdown.suggestionHeight + scrTop - that.$dropdown.maxHeight);
                        else if (selTop < 0)
                            that.$dropdown.scrollTop(selTop + scrTop);
                    }
            }
            
        },
        source: function (term) {
            var that = this;
            term = term.toLowerCase();
            if (term == "") {
                that.$input.val("");
            }
            var source = this.getSourceList()
            var choices = source.map(val => val.value);
            var matches = [];
            var others = [];
            for (i = 0; i < choices.length; i++) {
                if (~choices[i].toLowerCase().indexOf(term)) {
                    matches.push(source[i]);
                } else {
                    others.push(source[i]);
                }
            }
            if (that.options.showAll) {
                that.suggest(matches.concat(others));
            } else {
                that.suggest(matches);
            }
        },
        renderItem: function (item, search) {
            var that = this;
            search = search.replace(/[-\/\\^$*+?.()|[\]{}]/g, '\\$&');
            var re = new RegExp("(" + search.split(' ').join('|') + ")", "gi");
            return '<div class="txdAutoSuggest-suggestion" data-id="' + item.id + '" data-val="' + item.value + '">' + item.value.replace(re, "<b>$1</b>") + '</div>';
        },
        singleMatch: function () {
            var that = this;
            var internal_term = that.$el.val();
            if (internal_term == "") {
                that.$input.val("").trigger("change");
            }
            var source = this.getSourceList()
            var choices = source.map(val => val.value);
            var found = false;
            for (i = 0; i < choices.length; i++) {
                if (choices[i].toLowerCase() == internal_term.toLowerCase()) {
                    var elem = source[i];
                    that.$el.val(internal_term);
                    that.$input.val(elem.id).trigger("change");
                    found = true;
                    break;
                }
            }
            if (!found){
                if(that.options.allowNoMatch) {
                    that.$input.val(that.$el.val()).trigger("change");
                }else{
                    that.$el.val("");
                    that.$input.val("").trigger("change");
                }
            }
        },
        onSelect: function (event, term, item) {
            var that = this;
            var id = $(item).attr("data-id");
            that.$el.val(term);
            that.$input.val(id).trigger("change");
        },
        suggest: function (data) {
            var that = this;
            var val = that.$el.val();
            that.cache[val] = data;
            if (data.length && val.length >= that.options.minChars) {
                var s = '';
                for (var i = 0; i < data.length; i++) s += that.renderItem(data[i], val);
                that.$dropdown.html(s);
                that.updateSC(0);
            } else {
                that.$dropdown.hide();
            }
        },
        findValueInSource: function (idx_source, nome) {
            var obj = getSourceList();

            for (var i in obj) {


                if (obj[i]["value"].toLowerCase() === nome.toLowerCase()) {
                    return obj[i];
                }
            }

            return undefined;
        },
        findIdInSource: function (idx_source, id) {
            const obj = this.getSourceList();
            
            for (let entry of obj) {
                let straightCheck = entry.id === id
                let stringCheck = false
                if(!straightCheck && id!=null&&entry.id!=null){
                    stringCheck = entry.id.toString().toLowerCase() === id.toString().toLowerCase()
                }
                if (straightCheck||stringCheck) {
                    return entry;
                }
            }

            return undefined;
        },
        getSourceList: function(){
            if(!elenco_source_autocomplete.hasOwnProperty(this.idx_source)){
                console.warn("txd-autosuggest - source "+this.idx_source+" is missing")
            }
            const obj = elenco_source_autocomplete[this.idx_source] ?? [];

            return obj.filter(el => !this.options.nullValues.includes(el.id));
        }
    }

    $.fn.txdAutoSuggest = function () {
        var option = arguments[0],
            args = arguments,

            value,
            allowedMethods = [
                'destroy'
            ];
        this.filter("input:not(.txd_autosuggest_processed), select:not(.txd_autosuggest_processed)").each(function (id,el) {
            var $this = $(el),
                data = $this.data('txdAutoSuggest'),
                options = $.extend({}, $.fn.txdAutoSuggest.defaults,
                    $this.data(), typeof option === 'object' && option);


            if (!data) {
                data = new txdAutoSuggest($this, options);
                $this.data('txdAutoSuggest', data);
                data.init();
            }

            if (typeof option === 'string') {
                if ($.inArray(option, allowedMethods) < 0) {
                    throw 'Unknown method: ' + option;
                }
                value = data[option](args[1]);

                if (option === 'destroy') {
                    $this.removeData('txdAutoSuggest');
                }
            } else {
                if (args[1]) {
                    value = data[args[1]].apply(data, [].slice.call(args, 2));
                }
            }
        });

        return typeof value !== 'undefined' ? value : this;
    };


    $.fn.txdAutoSuggest.defaults = {
        source: txdAutoSuggest.prototype.source,
        renderItem: txdAutoSuggest.prototype.renderItem,
        singleMatch: txdAutoSuggest.prototype.singleMatch,
        onSelect: txdAutoSuggest.prototype.onSelect,
        verticalOffset: 0,
        minChars: 0,
        delay: 150,
        cache: false,
        menuClass: '',
        showAll: false,
        allowNoMatch: false,
        noName: false,
        noSubmit: false,
        maxHeight: 254,
        width: 0,
        nullValues:[null,undefined,""]
    };
    $.fn.txdAutoSuggest.tools = {
        findValueInSource: txdAutoSuggest.prototype.findValueInSource,
        findIdInSource: txdAutoSuggest.prototype.findIdInSource,
    }
}(jQuery));

$(document).ready(function () {
    $(".txd_autosuggest, .txd-autosuggest").txdAutoSuggest();
});