<?php

namespace Txd\Tests\Unit;

use Txd\Tests\Moking\MockModel as MockModel;
use Txd\Tests\TestCase;
use Txd\txdFields;

class TxdModelTest extends TestCase{
    public function testPhpunitEnv()
    {
        $this->assertTrue(true);
    }

    public function testGetCampi()
    {
        $obj = new MockModel();
        $obj->init_db_fields();
        $obj->sample1 = "aaa";
        $settore_a = [];
        $settore_b = [];
        $temp = $obj->fields()->addText("sample_1")->add_settore(["a","b"]);
        $settore_a[] = $temp;
        $settore_b[] = $temp;
        $temp = $obj->fields()->addText("sample_2")->add_settore(["a","b"]);
        $settore_a[] = $temp;
        $settore_b[] = $temp;
        $temp = $obj->fields()->addText("sample_3")->add_settore(["a","b"]);
        $settore_a[] = $temp;
        $settore_b[] = $temp;
        $temp = $obj->fields()->addText("sample_4")->add_settore(["a","b"]);
        $settore_a[] = $temp;
        $settore_b[] = $temp;
        $temp = $obj->fields()->addText("sample_a_1")->add_settore(["a"]);
        $settore_a[] = $temp;
        $temp = $obj->fields()->addText("sample_a_2")->add_settore("a");
        $settore_a[] = $temp;
        $temp = $obj->fields()->addText("sample_b_1")->add_settore(["b"]);
        $settore_b[] = $temp;
        $temp = $obj->fields()->addText("sample_b_2")->add_settore("b");
        $settore_b[] = $temp;

        $obj->init_db_fields();
        $dbFields = $obj->fields();
        
        $this->assertEquals($dbFields,$obj->get_campi(),"dbFields completo");
        $this->assertEquals($settore_a,$obj->get_campi("a"),"solo a ");
        $this->assertEquals($settore_b,$obj->get_campi("b"),"solo b");
    }

    public function testGetCampi_settori_come_params()
    {
        $obj = new MockModel();
        $obj->init_db_fields();
        $obj->sample1 = "aaa";
        $settore_ab = [];
        $temp = $obj->fields()->addText("sample_1")->add_settore(["a","b"]);
        $settore_ab[] = $temp;
        $temp = $obj->fields()->addText("sample_2")->add_settore(["a","b"]);
        $settore_ab[] = $temp;
        $temp = $obj->fields()->addText("sample_3")->add_settore(["a","b"]);
        $settore_ab[] = $temp;
        $temp = $obj->fields()->addText("sample_4")->add_settore(["a","b"]);
        $settore_ab[] = $temp;
        $temp = $obj->fields()->addText("sample_a_1")->add_settore(["a"]);
        $settore_ab[] = $temp;
        $temp = $obj->fields()->addText("sample_a_2")->add_settore("a");
        $settore_ab[] = $temp;
        $temp = $obj->fields()->addText("sample_b_1")->add_settore(["b"]);
        $settore_ab[] = $temp;
        $temp = $obj->fields()->addText("sample_b_2")->add_settore("b");
        $settore_ab[] = $temp;

        $obj->init_db_fields();
        $dbFields = $obj->fields();
        
        $settori = ["a","b"];        

        $this->assertEquals($dbFields,$obj->get_campi());
        $this->assertEquals($settore_ab,$obj->get_campi("a","b"));
        $this->assertEquals($settore_ab,$obj->get_campi("b","a"));
        $this->assertEquals($settore_ab,$obj->get_campi($settori));

    }

    public function testInizializzaCampi()
    {
        $fillable = ["sample_1","sample_2","sample_3","sample_4","sample_a_1","sample_a_2","sample_b_1","sample_b_2"];
        $fillable_a = ["sample_1","sample_2","sample_3","sample_4","sample_a_1","sample_a_2"];
        $fillable_b = ["sample_1","sample_2","sample_3","sample_4","sample_b_1","sample_b_2"];
        
        txdFields::$AUTO_APPLY_DB_FIELDS = false;

        $obj = new MockModel();
        $obj->init_db_fields();
        $obj->inizializzaCampi();
        $this->assertEquals($fillable,$obj->fillable,"standard");
        
        $obj = new MockModel();
        $obj->init_db_fields();
        $obj->inizializzaCampi("a");
        $this->assertEquals($fillable_a,$obj->fillable,"inizializza solo a");
        
        $obj = new MockModel();
        $obj->init_db_fields();
        $obj->inizializzaCampi("b");
        $this->assertEquals($fillable_b,$obj->fillable,"inizializza solo b");

        $obj = new MockModel();
        $obj->init_db_fields();
        $obj->inizializzaCampi("a","b");
        $this->assertEquals($fillable,$obj->fillable,"inizializza a+b");

        $obj = new MockModel();
        $obj->init_db_fields();
        $obj->inizializzaCampi("b","a");
        $this->assertEquals($fillable,$obj->fillable,"inizializza b+a");
    }
}