<?php
namespace Txd\FieldTypes;
/**
 * Tipo txdAttributes per hidden select
 * lato interfaccia e' a tutti gli effetti un campo hidden ma supporta la validazione delle select accettando solo i valori presenti in un option select
 */
class HiddenSelect extends \Txd\FieldTypes\Select {
    public function __construct($nome, $etichetta = "", $classi_html = []){
        // parent::__construct($nome,"select",$etichetta, $classi_html);
        parent::__construct($nome,"hidden",$etichetta, $classi_html);
    }

    public function tipo_campo_form(){
        return "hidden";
    }

    public function build_view(){
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }
        return e($this->get_valore());
    }

    public function build_edit(){
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }
        return view("txd::FieldTypes.Hidden",["campo_obj"=>$this]);
    }

}
