<?php

namespace Txd\Facades;

use Illuminate\Support\Facades\Facade;
/**
 * @method static \Txd\txdFields reduce(array|string $settori = [])
 * @method static \Txd\txdFields sort(callable $sorting_function = null,string $sector = "default")
 * @method static array toArray(string $sector = null) 
 * @method static \Txd\txdAttributes add($nome,$typeName = "Txd\FieldTypes\Text", $etichetta = "", $classi_html = [])
 * @method static void remove(string $fieldName,string $sector = "default")
 * @method static \Txd\txdAttributes addField(\Txd\txdAttributes $field, array|string $sectors = [])
 * @method static \Txd\txdAttributes retrieve(string $fieldName, string $sector = null)
 * @method static void set_current_model_obj($obj)
 * @method static void build()
 * @method static string verification_field()
 * @method static \Txd\txdFields getInstance()
 * @method static \Txd\txdFields addSector(string $sector, \Closure $sector_definition,bool $add_to_parent_sector = false)
 * @method static \Txd\txdFields deleteSector(string $sector)
 * @method static \Txd\txdFields editSector(string $sector, \Closure $sector_definition)
 * @method static \Txd\txdFields cloneSector(string $source,string $new_sector, \Closure $sector_definition = null)
 * @method static \Txd\txdFields mergeSectors($sources = [],string $new_sector)
 * @method static \Txd\txdFields setSectorAutomaticMerge(string $sector, bool $enable)
 * @method static void addFieldToSectors(\Txd\txdAttributes $field,array $sectors)
 * @method static void removeFieldFromSectors(\Txd\txdAttributes $field,array $sectors,bool $all = false)
 * @method static void moveField(\Txd\txdAttributes $field,string $fieldName,bool $before = false)
 * 
 * @method static \Txd\FieldTypes\Text addText($nome,$etichetta = "",$classi_html = [])
 * @method static \Txd\FieldTypes\Date addDate($nome,$etichetta = "",$classi_html = [])
 * @method static \Txd\FieldTypes\Datetime addDatetime($nome,$etichetta = "",$classi_html = [])
 * @method static \Txd\FieldTypes\Valuta addValuta($nome,$etichetta = "",$classi_html = [])
 * @method static \Txd\FieldTypes\Select addSelect($nome,$etichetta = "",$classi_html = [])
 * @method static \Txd\FieldTypes\HiddenSelect addHiddenSelect($nome,$etichetta = "",$classi_html = [])
 * @method static \Txd\FieldTypes\Email addEmail($nome,$etichetta = "",$classi_html = [])
 * @method static \Txd\FieldTypes\Password addPassword($nome,$etichetta = "",$classi_html = [])
 * @method static \Txd\FieldTypes\Number addNumber($nome,$etichetta = "",$classi_html = [])
 * @method static \Txd\FieldTypes\Checkbox addCheckbox($nome,$etichetta = "",$classi_html = [])
 * @method static \Txd\FieldTypes\Textarea addTextarea($nome,$etichetta = "",$classi_html = [])
 * @method static \Txd\FieldTypes\Html addHtml($nome,$etichetta = "",$classi_html = [])
 * @method static \Txd\FieldTypes\StaticHtml addStaticHtml($nome,$etichetta = "")
 * @method static \Txd\FieldTypes\Hidden addHidden($nome,$etichetta = "",$classi_html = [])
 * @method static \Txd\FieldTypes\File addFile($nome,$etichetta = "",$classi_html = [])
 * @method static \Txd\FieldTypes\Autosuggest addAutosuggest($nome,$etichetta = "",$classi_html = [])
 */
class DbFields extends Facade
{
    protected static function getFacadeAccessor()
    {
        
        return app("dbFields");
    }
}