<?php

namespace Txd\Traits\FieldTypes;



use Opis\Closure\SerializableClosure;
trait AddScopeTrait {

    protected $query_scope = null;
    protected $query_scope_params = [];
    
    /**
     * assegna la funzione di scope per quando il campo viene usato come filtro.
     * $scope può essere una closure o una stringa. nel caso la stringa sia "ricerca", il primo parametro di $scopeArgs deve essere un array con i nomi delle colonne in cui cercare
     * @param string|\Closure $scope
     * @param mixed ...$scopeArgs
     * 
     * @return $this
     */
    public function scope($scope,...$scopeArgs)
    {   
        if(is_a($scope,\Closure::class)){
            $scope = new SerializableClosure($scope);
        }
        $this->query_scope = $scope;
        $this->query_scope_params = $scopeArgs;

        return $this;
    }

    /**
     * applica lo scope definito nel campo su $query
     * @param mixed $query
     * 
     * @return mixed
     */
    public function applyScope($query){
        if(is_a($this->query_scope,SerializableClosure::class)){
            $query = ($this->query_scope)($query,$this->get_valore(true),...$this->query_scope_params);
        }elseif(is_null($this->query_scope)){
            $query = $this->defaultScope($query,$this->get_valore(true));
        }else{
            $scope = "scope".\Illuminate\Support\Str::studly($this->query_scope);
            if($scope === "scopeRicerca" && !method_exists($this->current_model_obj,$scope)){
                $query = $this->defaultScopeRicerca($query,$this->get_valore(true),...$this->query_scope_params);
            }else{
                $query = call_user_func_array([$this->current_model_obj, $scope], array_merge([$query,$this->get_valore(true)],$this->query_scope_params));
            }
        }
        return $query;
    }

    /**
     * scope di default: equivalente a ->where([nome_campo],$value)
     * @param mixed $query
     * @param mixed $value
     * 
     * @return mixed
     */
    public function defaultScope($query,$value){
        if(!is_null($value)){
            return $query->where($this->nome_campo,$this->get_valore(true));
        }
        return $query;
    }

   
    /**
     * scope di ricerca testuale. $fields deve contenere i nomi delle colonne in cui cercare
     * @param mixed $query
     * @param mixed $value
     * @param array $fields
     * 
     * @return mixed
     */
    public function defaultScopeRicerca($query, $value, array $fields){
		$value = trim($value);
		
		if(strlen($value) > 0){
			$query->where(function($query) use ($value,$fields){
                foreach($fields as $field){
                    $query->orWhere($field, "like", "%".$value."%");
                }
			});
		}

		return $query;
	}
}