<?php
namespace Txd\FieldTypes;
/**
 * Tipo txdAttributes per select
 */
class Select extends \Txd\txdAttributes {
    public function __construct($nome, $etichetta = "", $classi_html = []){
        parent::__construct($nome,"select",$etichetta, $classi_html);
    }

    /**
     * se il valore corrente è presente tra le opzioni ritorniamo l'etichetta corrispondente. altrimenti ritorniamo il valore vuoto
     *
     * @param mixed $valore
     * @return string
     */
    public function parse_valore($valore) {
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }
        
        $arr_valore = [$valore];
        if($this->is_multiple()){
            $arr_valore = $valore;
            // controllo per retrocompatibilità
            if(!is_array($arr_valore)) $arr_valore = json_decode($valore,true) ?? [];
            // fine controllo per retrocompatibilità
        }
        $out = implode(", ",array_map(function($val){
            if(isset($this->opzioni_select[$val])){
                    if(is_array($this->opzioni_select[$val])){
                        return $this->opzioni_select[$val]['option_value'];
                    }else{
                        return $this->opzioni_select[$val];
                    }
                }else{
                    return "";
                }
        },$arr_valore));

        return $out;
    }

    public function init_tipo(){
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }
    }

    public function tipo_campo_form(){
        return "select";
    }

    public function build_view(){
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }
        return e($this->get_valore());
    }
    
    public $only_present_values = false;
    public function build_edit(){
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }
        if($this->only_present_values){
            /** @var \Illuminate\Support\Collection */
            if(method_exists($this->current_db_fields,"final_query")){
                $allowed_values = $this->current_db_fields->final_query()->pluck($this->nome_campo,$this->nome_campo)->toArray();
                $this->opzioni_select = array_intersect_key($this->opzioni_select,$allowed_values);
            }else{
                \Log::warning(__METHOD__." - FieldType '".static::class."' -  txdFields->final_query() is not supported. Check if the package txd/forms is installed and updated, or disable the only_present_values attribute");
            }
        }
        return view("txd::FieldTypes.Select",["campo_obj"=>$this]);
    }


    private $validator = null;
    /**
     * abilita/disabilita la validazione del valore assegnato al campo con i valori presenti come chiavi in $this->opzioni_select
     * 
     * @param bool $enable
     * 
     * @return $this
     */
    public function option_validation_rule($enable = true){
        if($enable){
            if(is_null($this->validator)){
                $this->validator = function($attribute,$value,$fail){
                    if(!array_key_exists($value,$this->opzioni_select)){
                        $fail($value." is not a valid option");
                    }
                };
                $this->add_rule($this->validator);
            }
        }else{
            if(!is_null($this->validator)){
                $this->remove_rule($this->validator);
                $this->validator = null;
            }
        }

        return $this;
    }

    /**
     * @return bool
     */
    public function is_multiple(){
        return array_key_exists("multiple",$this->html_attributes);
    }
    // reimplementazione opzioni_select

    public $opzioni_select = [];
    
    /**
     * permette di impostare o recuperare le opzioni per i select a seconda del parametro ricevuto
     * @param NULL|array $info se NULL recupera le opzioni settate, se e' un array le imposta
     * @return $this|null 
     * @throws \Exception
     */
    public function opzioni_select($info = null){
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }

        if(is_null($info)){
            return $this->opzioni_select;
        }elseif(!is_array($info)){
            throw new \Exception(__FUNCTION__ ."() needs an array as parameter, ".gettype($info)." given");
        }else{
            $this->opzioni_select = $info;
        }

        return $this;
    }

    /**
     * Genera il nome del campo. Estensione del metodo base per gestire i select di tipo multiple
     * @param string $prefix prefisso al nome del campo (senza [])
     * @return string
     */
    public function build_nome_campo($prefix=null){
        return parent::build_nome_campo($prefix).($this->is_multiple()?"[]":"");
    }

    
}
