<?php
namespace Txd\FieldTypes;
/**
 * Tipo txdAttributes per File
 */
class File extends Text {
    public function __construct($nome, $etichetta = "", $classi_html = []){
        parent::__construct($nome,$etichetta, $classi_html);
        $this->tipo_campo = "file";
    }

    public function tipo_campo_form(){
        return "file";
    }

    public function build_edit(){
        if(class_exists("jsmDoc")){ \jsmDoc::log_method(__FUNCTION__, get_called_class(), __FILE__); }

        $allowed_extensions = array_flatten(array_map(function($el){

            [$prefix, $extensions] = explode(":", $el);

            return array_map(function($ext){ return strlen($ext) > 0 ? ".".$ext : null; }, explode(",", $extensions));

        }, array_filter($this->get_model_rules() ?? [], function($el){
            return \Illuminate\Support\Str::startsWith($el, "extensions:");
        })));

        return view("txd::FieldTypes.File", ["campo_obj" => $this, "allowed_extensions" => join(",", $allowed_extensions)]);
    }
}