<?php
namespace Txd\FieldTypes;
/**
 * Tipo txdAttributes per datatime
 */
class Datetime extends Text {
    public $parse_options = [];

    public function __construct($nome, $etichetta = "", $classi_html = []){
        parent::__construct($nome,$etichetta, $classi_html);
        $this->tipo_campo = "datatime";
    }

    public function parse_valore($valore) {
        
        $value = \Illuminate\Support\Carbon::stampa_data($valore,$this->parse_options);
        
        $re = '/^\d+$/';
        if(preg_match($re, $value)===1){
            $value = (int)$value;
        }

        return $value;
    }

    public function optFormat(string $format){
        $this->parse_options["format"] = $format;
        return $this;
    }

    public function init_tipo(){
        $this->add_classe_html("datatime_picker");
        $this->set_model_type("datetime");
    }

    public function withSeconds($value = true){
        if($value){
            $this->set_html_attribute("data-no-seconds");
        }else{
            $this->remove_html_attribute("data-no-seconds");
        }
    }

    public function tipo_campo_form(){
        return "parse_value";
    }

    public function build_edit(){
        
        return view("txd::FieldTypes.Datetime",["campo_obj"=>$this]);
    }
}