<?php
namespace Txd\FieldTypes;
/**
 * Tipo txdAttributes per valuta
 */
class Valuta extends Text {
    public function __construct($nome, $etichetta = "", $classi_html = []){
        parent::__construct($nome,$etichetta, $classi_html);
        $this->tipo_campo = "valuta";
    }

    public function parse_valore($valore) {
        
        if(is_numeric($valore)){
            $valore = number_format($valore, "2", ",", ".");
        }
        return $valore;
    }

    public function init_tipo(){
        
        $this->add_rule("nullable|numeric");
        $this->set_model_type("valuta");
    }

    public function tipo_campo_form(){
        return "parse_value";
    }

    public function build_edit(){
        
        return view("txd::FieldTypes.Valuta",["campo_obj"=>$this]);
    }
}