<?php

if(!function_exists("localUniqueString")){
	global $localUniqueStringHistory;
    $localUniqueStringHistory = [];
    /**
     * genera una stringa random garantita per la chiamata corrente
     * 
     * @return string
	 * 
     */
	function localUniqueString($prefix=null,$length=10) {
		global $localUniqueStringHistory;
		$string = $prefix.bin2hex(random_bytes($length));
		while(array_key_exists($string,$localUniqueStringHistory)) {
			$string = $prefix.bin2hex(random_bytes($length));
		}
		$localUniqueStringHistory[$string] = null;

		return $string;
	}
}

if(!function_exists("carbonParse")){
	function carbonParse($time=null,$tz = null) {
		if(\Illuminate\Support\Carbon::hasMacro("parseWithDefault")){
			return \Illuminate\Support\Carbon::parseWithDefault($time,$tz);	
		}
		
		return \Illuminate\Support\Carbon::parse($time,$tz);
		
	}
}

if(!function_exists("carbonStampaData")){
	function carbonStampaData($data,$options) {
		if(\Illuminate\Support\Carbon::hasMacro("stampa_data")){
			return \Illuminate\Support\Carbon::stampa_data($data,$options);
		}
		$format = (isset($options['format']) ? $options['format'] : null);
		$escape = (isset($options['escape']) ? $options['escape'] : "");
		if($format === null){
			$format = config("par.date_format", "d/m/Y");
			$format = config("par.datetime_format", $format);
		}
		return $data->format($format);
	}
}