<?php

namespace Txd\FieldTypes;

use Laravel\SerializableClosure\SerializableClosure;

class ExtraSuggest extends \Txd\FieldTypes\Text {
    public function __construct($nome, $etichetta = "", $classi_html = [])
    {
        parent::__construct($nome,$etichetta,$classi_html);
        $this->add_classe_html("extrasuggest");
    }
    
    public function optLoadFromAjax($urlOrClosure,$searchable = false){
        if(is_callable($urlOrClosure)){
            $identifier = \Txd\FieldTypes\ExtraSelect::searchMethodPut($urlOrClosure);
            $url = route("extraselect.search",["identifier"=>$identifier]);
            $StartingElement = $urlOrClosure(null,$this->get_valore(true));
            if(count($StartingElement)>0){
                $this->opzioni_select([$StartingElement[0]["key"] => $StartingElement[0]["value"]]);
            }
        }else{
            $url = $urlOrClosure;
        }
        
        $this->add_html_attribute("data-url",$url);
        $this->add_html_attribute("data-searchable-url",$searchable);
        $this->add_html_attribute("data-fetch-options",json_encode(["body"=>["_token"=>csrf_token()]]));
        return $this;
    }
    
    public function optMinChars($minChars = 0){
        $this->add_html_attribute("data-min-chars",$minChars);
        return $this;
    }
    
    public function render_edit()
    {
        $formattedOptions = [];
        foreach($this->opzioni_select ?? [] as $key => $value){
            $formattedOptions[] = ["key" => $key,"value" => $value];
        }
        $this->add_html_attribute("data-options",json_encode($formattedOptions));
        return parent::render_edit();
    }
    
    protected $__opzioni_select;
    public function __get($name)
    {
        if($name ==="opzioni_select"){
            $value = $this->__opzioni_select;
            if(is_callable($value)){
                $value = $value($this);
                $this->__opzioni_select = $value;
            }
            return $value;
        }
        return $this->$name ?? null;
    }
    public function __set($name,$value)
    {
        if($name ==="opzioni_select"){
            $this->__opzioni_select = $value;
            return;
        }
        $this->$name = $value;

    }

    /**
     * permette di impostare o recuperare le opzioni per i select a seconda del parametro ricevuto
     * @param NULL|array $info se NULL recupera le opzioni settate, se e' un array le imposta
     * @return $this|null 
     * @throws \Exception
     */
    public function opzioni_select($info = null){
        

        if(is_null($info)){
            return $this->opzioni_select;
        }elseif(!is_array($info) && !is_callable($info)){
            throw new \Exception(__FUNCTION__ ."() needs an array or a callable as parameter, ".gettype($info)." given");
        }else{
            $this->opzioni_select = $info;
        }

        return $this;
    }
}