<?php
namespace Txd\Tests\Moking;

use Txd\Traits\txdModel;
use Txd\txdFields;
use Watson\Validating\ValidatingTrait;

class MockModel {
    use txdModel;
    use ValidatingTrait;

    public $fillable = [];
    public $rules = [];
    public $types = [];
    public $html_capable_fields = [];

    public function add_html_field($nome_campo){
        if(array_search($nome_campo, $this->html_capable_fields, true) === false){
            $this->html_capable_fields[] = $nome_campo;
        }
    }

    public function init_db_fields() {

        
        
        if(is_null($this->db_fields)){
            $db_fields = new txdFields($this);
            
            $db_fields->addText("sample_1")->add_settore(["a","b"]);
            $db_fields->addText("sample_2")->add_settore(["a","b"]);
            $db_fields->addText("sample_3")->add_settore(["a","b"]);
            $db_fields->addText("sample_4")->add_settore(["a","b"]);
            $db_fields->addText("sample_a_1")->add_settore(["a"]);
            $db_fields->addText("sample_a_2")->add_settore("a");
            $db_fields->addText("sample_b_1")->add_settore(["b"]);
            $db_fields->addText("sample_b_2")->add_settore("b");
            $this->inizializzaCampi();
        }
    }

    

    /**
     * rimuove l'attributo passato dall'elenco dei campi che supportano l'html
     * 
     * @param string $nome_campo
     */
    public function remove_html_field($nome_campo){
        if (($key = array_search($nome_campo, $this->html_capable_fields, true)) !== false) {
            unset($this->html_capable_fields[$key]);
        }
    }
}