<?php

namespace Txd\FieldTypes;



class ExtraSelect extends \Txd\FieldTypes\Select {
    public function __construct($nome, $etichetta = "", $classi_html = [])
    {
        parent::__construct($nome,$etichetta,$classi_html);
        $this->add_classe_html("extraselect");
    }
    
    /**
     * Metodo per abilitare il caricamento del Select tramite ajax e supporto per abilitare la ricerca in ajax.
     * La Closure deve ritornare un array di oggetti nella forma ["key"=>'chiave',"value" => 'value'].
     * Per supportare la ricerca la closure deve poter ricevere 2 parametri: 
     * $search come stringa, chiave di ricerca 
     * $key, per la raccolta di elementi singoli con match esatto della chiave
     * 
     * per la definizione della closure si può usare l'helper optionSelectSearch()
     * 
     * @param mixed $urlOrClosure
     * @param bool $searchable
     * 
     * @return $this
     */
    public function optLoadFromAjax($urlOrClosure,$searchable = false){
        if(is_callable($urlOrClosure)){
            $identifier = static::searchMethodPut($urlOrClosure);
            $url = route("extraselect.search",["identifier"=>$identifier]);
            $StartingElement = $urlOrClosure(null,$this->get_valore(true));
            if(count($StartingElement)>0){
                $this->opzioni_select([$StartingElement[0]["key"] => $StartingElement[0]["value"]]);
            }
        }else{
            $url = $urlOrClosure;
        }
        
        $this->add_html_attribute("data-url",$url);
        $this->add_html_attribute("data-searchable-url",$searchable);
        $this->add_html_attribute("data-fetch-options",json_encode(["body"=>["_token"=>csrf_token()]]));
        return $this;
    }
    
    public function optSearch($enable = true,$minChars = 0){
        $this->add_html_attribute("data-search",$enable);
        $this->add_html_attribute("data-min-chars",$minChars);
        return $this;
    }
    
    public static function searchMethodPut($callback,string $identifier = null){
		$serializable = new \Laravel\SerializableClosure\Serializers\Native($callback);
		if(is_null($identifier)){
			$code = $serializable->getReflector()->getCode();
			$variables = $serializable->getReflector()->getUseVariables();
			$identifier = md5(json_encode(["code" => $code, "variables" => $variables]));
		}
		session()->put("extraselect.$identifier",$serializable);
		return $identifier;
	}
    
    public static function searchMethodGet(string $identifier, $searchTerm){
		$serializedCallback = session()->get("extraselect.$identifier");
        $callback = $serializedCallback?->getClosure();
        if(is_callable($callback)){
		    return $callback($searchTerm);
        }
        return [];
	}
}