<?php 

namespace Txd\Traits\FieldTypes;

use Txd\txdFields;

trait AddTypesTrait {

    /**
     * Aggiunge un campo di tipo Text
     *
     * @param string $nome nome del campo
     * @param string $etichetta etichetta stampata nel form
     * @param array $classi_html classi html aggiuntive per il campo
     * @return \Txd\FieldTypes\Text
     */
    public function addText($nome,$etichetta = "",$classi_html = []){
        return $this->add($nome,\Txd\FieldTypes\Text::class,$etichetta,$classi_html);
    }
    
    /**
     * Aggiunge un campo di tipo Date
     *
     * @param string $nome nome del campo
     * @param string $etichetta etichetta stampata nel form
     * @param array $classi_html classi html aggiuntive per il campo
     * @return \Txd\FieldTypes\Date
     */
    public function addDate($nome,$etichetta = "",$classi_html = []){
        return $this->add($nome,\Txd\FieldTypes\Date::class,$etichetta,$classi_html);
    }
    
    /**
     * Aggiunge un campo di tipo Datetime
     *
     * @param string $nome nome del campo
     * @param string $etichetta etichetta stampata nel form
     * @param array $classi_html classi html aggiuntive per il campo
     * @return \Txd\FieldTypes\Datetime
     */
    public function addDatetime($nome,$etichetta = "",$classi_html = []){
        return $this->add($nome,\Txd\FieldTypes\Datetime::class,$etichetta,$classi_html);
    }
    
    /**
     * Aggiunge un campo di tipo Valuta
     *
     * @param string $nome nome del campo
     * @param string $etichetta etichetta stampata nel form
     * @param array $classi_html classi html aggiuntive per il campo
     * @return \Txd\FieldTypes\Valuta
     */
    public function addValuta($nome,$etichetta = "",$classi_html = []){
        return $this->add($nome,\Txd\FieldTypes\Valuta::class,$etichetta,$classi_html);
    }
    
    /**
     * Aggiunge un campo di tipo Select
     *
     * @param string $nome nome del campo
     * @param string $etichetta etichetta stampata nel form
     * @param array $classi_html classi html aggiuntive per il campo
     * @return \Txd\FieldTypes\Select
     */
    public function addSelect($nome,$etichetta = "",$classi_html = []){
        return $this->add($nome,\Txd\FieldTypes\Select::class,$etichetta,$classi_html);
    }
    
    /**
     * Aggiunge un campo di tipo Email
     *
     * @param string $nome nome del campo
     * @param string $etichetta etichetta stampata nel form
     * @param array $classi_html classi html aggiuntive per il campo
     * @return \Txd\FieldTypes\Email
     */
    public function addEmail($nome,$etichetta = "",$classi_html = []){
        return $this->add($nome,\Txd\FieldTypes\Email::class,$etichetta,$classi_html);
    }
    
    /**
     * Aggiunge un campo di tipo Password
     *
     * @param string $nome nome del campo
     * @param string $etichetta etichetta stampata nel form
     * @param array $classi_html classi html aggiuntive per il campo
     * @return \Txd\FieldTypes\Password
     */
    public function addPassword($nome,$etichetta = "",$classi_html = []){
        return $this->add($nome,\Txd\FieldTypes\Password::class,$etichetta,$classi_html);
    }
    
    /**
     * Aggiunge un campo di tipo Number
     *
     * @param string $nome nome del campo
     * @param string $etichetta etichetta stampata nel form
     * @param array $classi_html classi html aggiuntive per il campo
     * @return \Txd\FieldTypes\Number
     */
    public function addNumber($nome,$etichetta = "",$classi_html = []){
        return $this->add($nome,\Txd\FieldTypes\Number::class,$etichetta,$classi_html);
    }
    
    /**
     * Aggiunge un campo di tipo Checkbox
     *
     * @param string $nome nome del campo
     * @param string $etichetta etichetta stampata nel form
     * @param array $classi_html classi html aggiuntive per il campo
     * @return \Txd\FieldTypes\Checkbox
     */
    public function addCheckbox($nome,$etichetta = "",$classi_html = []){
        return $this->add($nome,\Txd\FieldTypes\Checkbox::class,$etichetta,$classi_html);
    }
    
    /**
     * Aggiunge un campo di tipo Textarea
     *
     * @param string $nome nome del campo
     * @param string $etichetta etichetta stampata nel form
     * @param array $classi_html classi html aggiuntive per il campo
     * @return \Txd\FieldTypes\Textarea
     */
    public function addTextarea($nome,$etichetta = "",$classi_html = []){
        return $this->add($nome,\Txd\FieldTypes\Textarea::class,$etichetta,$classi_html);
    }
    
    /**
     * Aggiunge un campo di tipo Html
     *
     * @param string $nome nome del campo
     * @param string $etichetta etichetta stampata nel form
     * @param array $classi_html classi html aggiuntive per il campo
     * @return \Txd\FieldTypes\Html
     */
    public function addHtml($nome,$etichetta = "",$classi_html = []){
        return $this->add($nome,\Txd\FieldTypes\Html::class,$etichetta,$classi_html);
    }
    /**
     * Aggiunge un campo di tipo Html statico (edit e view mostrano sempre il valore del campo)
     *
     * @param string $nome nome del campo
     * @param string $etichetta etichetta stampata nel form
     * @return \Txd\FieldTypes\StaticHtml
     */
    public function addStaticHtml($nome,$etichetta = ""){
        return $this->add($nome,\Txd\FieldTypes\StaticHtml::class,$etichetta,[]);
    }
    
    /**
     * Aggiunge un campo di tipo Hidden
     *
     * @param string $nome nome del campo
     * @param string $etichetta etichetta stampata nel form
     * @param array $classi_html classi html aggiuntive per il campo
     * @return \Txd\FieldTypes\Hidden
     */
    public function addHidden($nome,$etichetta = "",$classi_html = []){
        return $this->add($nome,\Txd\FieldTypes\Hidden::class,$etichetta,$classi_html);
    }
    
    /**
     * Aggiunge un campo di tipo File
     *
     * @param string $nome nome del campo
     * @param string $etichetta etichetta stampata nel form
     * @param array $classi_html classi html aggiuntive per il campo
     * @return \Txd\FieldTypes\File
     */
    public function addFile($nome,$etichetta = "",$classi_html = []){
        return $this->add($nome,\Txd\FieldTypes\File::class,$etichetta,$classi_html);
    }
    /**
     * Aggiunge un campo di tipo Autosuggest. Preferire il tipo ExtraSelect
     *
     * @deprecated
     * @param string $nome nome del campo
     * @param string $etichetta etichetta stampata nel form
     * @param array $classi_html classi html aggiuntive per il campo
     * @return \Txd\FieldTypes\Autosuggest
     */
    public function addAutosuggest($nome,$etichetta = "",$classi_html = []){
        return $this->add($nome,\Txd\FieldTypes\Autosuggest::class,$etichetta,$classi_html);
    }
    
    public function addExtraSelect($nome,$etichetta = "",$classi_html = []){
        return $this->add($nome,\Txd\FieldTypes\ExtraSelect::class,$etichetta,$classi_html);
    }
    public function addExtraSuggest($nome,$etichetta = "",$classi_html = []){
        return $this->add($nome,\Txd\FieldTypes\ExtraSuggest::class,$etichetta,$classi_html);
    }
    
    /**
     * @param mixed $nome
     * @param string $etichetta
     * @param array $classi_html
     * 
     * @return \Txd\FieldTypes\VueTag
     */
    public function addVueTag($nome,$etichetta = "",$classi_html = []){
        return $this->add($nome,\Txd\FieldTypes\VueTag::class,$etichetta,$classi_html);
    }
    
    // supporto per aggiunta metodi dinamici per costruzione form (add[FieldType]) 
    public function __call($name, $args) {
        if(\Illuminate\Support\Str::startsWith($name,"add")){
            $className = substr($name,3);
            try{
                $class = txdFields::findClass($className);
            }catch(\Throwable $e){
                return parent::__call($name,$args);        
            }
            if($class !== Text::class){
                return $this->add($args[0],$class,$args[1] ?? "",$args[2] ?? []);   
            }

        }
        return parent::__call($name,$args);
    }
}