<?php

namespace Txd\FieldTypes\Enums;

class TXD_ATTRIBUTES_BUILD_MODE {
    /** 
     * Comportamento di default. Costruisce il campo in modalità view ed edit, con gli handler necessari a gestirne la visibilità
     * Build the field in both view and edit mode 
     * */
    const VIEW_AND_EDIT = 0;
    /** 
     * Costruisce il campo solo in modalità view. Verrà visualizzato in questo modo anche in un form di edit
     * Build the field in view mode only. It will be shown in this way also in an edit form 
     * */
    const VIEW_ONLY = 1;
    /** 
     * Costruisce il campo solo in modalità edit. Verrà visualizzato in questo modo anche in un form di view
     * Build the field in edit mode only. It will be shown in this way also in a view form 
     * */
    const EDIT_ONLY = 2;
}