<?php 

namespace Txd\Traits\FieldTypes;

use Exception;
use InvalidArgumentException;
use Txd\FieldTypes\DynamicAttributes\AttributesSet;
use Txd\FieldTypes\DynamicAttributes\DynamicAttribute;
use Illuminate\Support\Str;
use Txd\txdAttributes;

trait HasDynamicAttributesTrait {
    protected $dynamic_attribute_data = [];
    protected $dynamic_attribute_mutators_mapping = [];
    public $protected_dynamic_fields = [];
    protected $loaders =[];
    public function create_dynamic_fields(AttributesSet $attributes,$prefix,$target_attribute,callable $decorator = null){
        
        if(!array_key_exists($prefix,$this->dynamic_attribute_data)){
            $stud_prefix = Str::studly($prefix);
            foreach(array_keys($this->dynamic_attribute_data) as $p){
                if($p === $prefix) throw new InvalidArgumentException("Prefix already in use");
                if(Str::starts_with($p,$prefix) || Str::starts_with($prefix,$p)) throw new InvalidArgumentException("Prefix collision - $p : $prefix");
                $stud_p = Str::studly($p);
                if(Str::starts_with($stud_p,$stud_prefix) || Str::starts_with($stud_prefix,$stud_p)) throw new InvalidArgumentException("Prefix collision - $p : $prefix");
            }
            
            $this->dynamic_attribute_data[$prefix] = [
                "target" => $target_attribute,
                "names"=>$attributes->map(function($attr){ return $attr->name;})
            ];
            $this->dynamic_attribute_mutators_mapping["set".$stud_prefix] = $prefix;
            $this->dynamic_attribute_mutators_mapping["get".$stud_prefix] = $prefix;
            $self = $this;
            $loader = new \Laravel\SerializableClosure\SerializableClosure(function() use($self,$attributes,$prefix,$decorator){
                $self->fillDbFieldWithDynamics($attributes,$prefix,$decorator);
            });
            $this->loaders[] = $loader;
        }
    }

    public function load_dynamic_fields(){
        foreach($this->loaders as $loader){
            $loader();
        }
    }

    protected function fillDbFieldWithDynamics(AttributesSet $campi,string $prefix,callable $decorator){
        /** @var \Txd\txdFields */
        if(!\Txd\Facades\DbFields::getInstance()->throwaway){
            $db_fields = \Txd\Facades\DbFields::getInstance();
        }else{
            $db_fields = $this->fields();
        }
        
        foreach($campi as $campo){
            /** @var DynamicAttribute $campo */
            $nome = $campo->name;
            if($campo->name != Str::snake(Str::studly($campo->name))) throw new Exception("invalid dynamic field name - ".$campo->name);
            if(!in_array($nome,$this->protected_dynamic_fields)){
                $nome = $prefix.$nome;
                
                /** @var txdAttributes $field */
                $field = $db_fields->add($nome, $campo->type, $campo->label);

                if(!is_null($decorator)){
                    $decorator($campo,$field);
                }         
            }
        }
    }

    public function get_dynamic_fields_names($prefix = null){
        $keys = array_keys($this->dynamic_attribute_data);
        if(!is_null($prefix)){
            $keys = in_array($prefix,$keys)?[$prefix]:[];
        }
        return array_reduce($keys,function($c,$key){
            return array_merge($c,array_map(function($el) use ($key){
                return $key.$el;
            },$this->dynamic_attribute_data[$key]["names"]));
        },[]);
    }
    


    public function hasGetMutator($key)
    {
        return \Illuminate\Support\Str::startsWith($key,array_keys($this->dynamic_attribute_data)) || parent::hasGetMutator($key);
    }
    public function hasSetMutator($key)
    {
        return \Illuminate\Support\Str::startsWith($key,array_keys($this->dynamic_attribute_data)) || parent::hasSetMutator($key);
    }

    public function __call($method, $parameters)
    {
        if(Str::startsWith($method,array_keys($this->dynamic_attribute_mutators_mapping))&&Str::endsWith($method,"Attribute")){
            $campi_da_controllare = [];
            $campo_destinazione = "";

            foreach($this->dynamic_attribute_mutators_mapping as $stud_prefix => $prefix){
                if(Str::startsWith($method,$stud_prefix)){
                    $p_length = strlen($stud_prefix);
                    $parsed = Str::snake(substr($method,$p_length,strlen($method)-(9+$p_length)));
                    $campi_da_controllare = $this->dynamic_attribute_data[$prefix]["names"];
                    $campo_destinazione = $this->dynamic_attribute_data[$prefix]["target"];    
                    break;
                }    
            }
            
            if(in_array($parsed,$campi_da_controllare)){
                $valori = json_decode($this->$campo_destinazione,true) ?? [];
                if(Str::startsWith($method,"get")){
                    return $valori[$parsed] ?? null;
                }else if(count($parameters)>0){
                    $valori[$parsed] = $parameters[0];
                    $this->$campo_destinazione = json_encode($valori);
                    return;
                }
            }
        }
        return parent::__call($method,$parameters);
    }
}