<?php

namespace Txd\Traits;

use Txd\Facades\DbFields;
use Txd\txdAttributes;
use Txd\txdFields;


trait txdModel {
    
    /**
     * se impostato a TRUE chiama il metodo init_db_fields direttamente nel costruttore (cosi' che siano disponibili fin da subito fillable e simili)
     * 
     * @var boolean
     */
    public static $AUTO_LOAD_DB_FIELDS = true;
    

    protected ?txdFields $db_fields = null;
    /**
     * abilita la costruzione del nome campo complesso
     *
     * @var boolean
     */
    public $txdPrefixEnable = false;
    /**
     * Experimental: flag per abilitare il caching dei campi
     * @var bool
     */
    public $cache_enabled = false;
    /**
     * popola l'elenco degli attributi legati al database
     * 
     * [placeholder da sostituire con i campi che verranno poi stampati nel form]
     * 
     */

	public function init_db_fields($sectors = null) {
        if(!is_null($sectors)){
            $this->db_fields = null;
            if(is_string($sectors)) $sectors = [$sectors];
        }else{
            $sectors = [];
        }
        if(is_null($this->db_fields)){
            $db_fields = $this->cache_enabled ?cache('db_fields.'.static::class):null;
            if(is_null($db_fields)){
                $db_fields = new txdFields($this);
                $this->set_db_fields($db_fields);
                DbFields::pushInstance($db_fields);
                
                
                $this->db_fields_definition($db_fields);
                $db_fields->sort();
                DbFields::popInstance();
                $this->cache_enabled ?cache(['db_fields.'.static::class=>$db_fields],now()->addSeconds(30)):"";
            }else{
                $this->set_db_fields($db_fields);
            }
            if(count($sectors)>0){
                $this->db_fields = $db_fields->reduce($sectors,true);
            }
            $this->inizializzaCampi();
        }
    }
    
    /**
     * imposta l'attributo locale db_fields
     * 
     * @param txdFields $txdField
     */
    public function set_db_fields(txdFields $txdField){
        $this->db_fields = $txdField;
    }

    /**
     * funzione per isolamento configurazione db_fields da codice boilerplate.
     * deve essere ridefinita nel modello. Se nel modello è stata ridefinita init_db_fields classico questo metodo non viene invocato
     * 
     * @param \Txd\txdFields $db_fields elemento da configurare
     * 
     * @return void
     */
    public function db_fields_definition($db_fields){

    }
    

    /**
     * ritorna un txdAttribute o txdFields (con tutti gli attribute) a seconda del parametro ricevuto
     * inizializa db_fields se e' la prima volta
     * 
     * @param string|null $fieldName settore da recuperare
     * * @param string|null $sector settore di origine
     * @return txdFields|txdAttributes
     */
    
    public function fields(string $fieldName = null,string $sector = null){
        

        $this->init_db_fields(); //cosi' che venga sempre popolato l'array anche se non fosse ancora stato chiamato

        if(is_string($fieldName) && strlen($fieldName) > 0){
            $out = $this->db_fields->retrieve($fieldName, $sector);
        }else{
            $out = $this->db_fields;
        }

        return $out;
    }
    
    public function formValues($raw = false){
        $out = [];
        foreach($this->get_campi() as $key => $field){
            $label = $key;
            
            $out[$label] = $field->get_valore($raw);
        }
        return $out;
    }
    /**
     * recupera tutti i campi di un determinato settore (o tutti in caso di NULL come parametro)
     * 
     * @param array|string $settori,... nome del settore o array vuoto per tutti i settori
     * @return \Txd\txdFields elenco degli attributi del settore richiesto
     */
	public function get_campi($settori = []) {
        

        if(is_string($settori)) $settori = [$settori];
        $this->init_db_fields(); //cosi' che venga sempre popolato l'array anche se non fosse ancora stato chiamato
        $new = $this->db_fields->reduce($settori,true);
        $new->source = $settori;
        return $new;
		
	}

    /**
     * ritorna un oggetto \Txd\txdFields con campi inizializzati secondo i settori passati, agganciato ad una entità nuova (new)
     * @param array|string $settori
     * 
     * @return \Txd\txdFields
     */
    public static function get_campi_statici($settori = []) {

        
        if(is_string($settori)) $settori = [$settori];
        $obj = new static();
        $obj->init_db_fields($settori);
        return $obj->get_campi();
		
	}
	
    
    /**
     * da invocare dopo aver definito i campi: va a settare regole, fillable, types, etc. sulla base di quanto definito
     * 
     */
	public function inizializzaCampi($settori = []) {
        
        
        
        if(is_string($settori)) $settori = [$settori];

        foreach ($this->get_campi($settori) as $campo){

            // $campo->set_current_model_obj($this); /** non dovrebbe piu' servire perche' l'abbiamo aggiunto al metodo add di txdAttributes */

			if(!$campo->skip_check_fillable){
				if($campo->isFillable()){
					$this->add_fillable($campo->nome_campo);
				}else{
					$this->remove_fillable($campo->nome_campo);
				}
            }
            
            $attribute_rules = array_merge($campo->get_model_rules(),$this->model_rules[$campo->nome_campo] ?? []);
            //convert | to array
            $attribute_rules = array_map(function($rule){ return is_string($rule)?explode("|",$rule):$rule;},$attribute_rules);
            // flatten resulting array
            $this->rules[$campo->nome_campo] =  \Illuminate\Support\Arr::flatten($attribute_rules);
		}
	}


	
	/**
     * rimuove un attributo dalla lista dei fillable
	 * @param string $param
	 * 
	 * @return void
	 */
	public function remove_fillable(string $param) {
        

		$indice = array_search($param, $this->fillable, true);
		if($indice!==false){
			unset($this->fillable[$indice]);
		}
	}
	
	/**
     * aggiunge un attributo alla lista dei fillable
	 * @param string $param
	 * 
	 * @return void
	 */
	public function add_fillable(string $param) {
        
		$this->fillable[] = $param;
	}

    public static function scopeWithPermissions($builder, $user_obj = null,$forceConstraints = false)
    {
        $callback = function() use ($builder,$user_obj){
            $nome_classe = get_class($builder->getModel());
            $nome_classe::applica_permessi($builder,$user_obj);
            return $builder;
        };

        if($forceConstraints){
            return \Txd\Relations\Relation::withConstraints($callback);
        }else{
            return $callback();
        }
    }

    public static function scopeWithRelationPermissions($builder, $user_obj = null,$forceConstraints = false)
    {
        if(!config("txd_fieldtypes.evaluate_permissions_in_relations", true)){
            return $builder;
        }
        
        return static::scopeWithPermissions($builder,$user_obj,$forceConstraints);
    }

    public static function scopeApplicaPermessi($builder, $user_obj = null,$forceConstraints = false)
    {
        return static::scopeWithPermissions($builder,$user_obj,$forceConstraints);
    }

}