@php
$id = localUniqueString("check_");
@endphp
@if($campo_obj->hasUrl() && !is_null($campo_obj->getUrl()))
    @if($campo_obj->isImage)
        <img src="{!!$campo_obj->getUrl()!!}" style='max-width:100%'>
    @else
        <a class="btn btn-secondary" target="_blank" href="{!!$campo_obj->getUrl()!!}"><i class="fa fas fa-file"></i></a>
    @endif
@endif
<div class="d-flex gap-xs justify-contents-between align-items-center">
<input 
    data-check="{{$id}}"
    type="{{$campo_obj->tipo_campo_form()}}" 
    name="{{$campo_obj->build_nome_campo($prefix ?? null)}}" 
    class="form-control {{$campo_obj->get_classi_html()}}" 
    placeholder="{{$campo_obj->placeholder}}"
    accept="{{$allowed_extensions ?? null}}"
    @foreach($campo_obj->html_attributes() as $key => $value)
        {{$key}}="{{$value}}"
    @endforeach
    {{ $campo_obj->isDisabled() ? "disabled" : "" }}
    />
    <a data-check="{{$id}}" class="btn btn-danger file-trash" title="{{trans("Elimina File")}}"><i class="fa fas fa-trash"></i> </a>
<input 
    type="checkbox" 
    value=""
    name="{{$campo_obj->build_nome_campo($prefix ?? null)}}" 
    id="{{$id}}"    
    hidden
    />
</div>
<script type="module">
    $(".file-trash[data-check='{{$id}}']").click(function(){
        let check = document.getElementById('{{$id}}')
        check.checked = !check.checked
        if(check.checked){
            $(this).addClass("btn-dark").removeClass("btn-danger");
            document.querySelector("input[data-check={{$id}}]").disabled = true
            check.disabled = false
        }else{
            $(this).removeClass("btn-dark").addClass("btn-danger");
            document.querySelector("input[data-check={{$id}}]").disabled = false
            check.disabled = true
        }
        console.log(check.checked,check.disabled)
    })
</script>