<?php
namespace Txd\FieldTypes;

use Txd\Traits\Scopes\HasDateRangeScope;

/**
 * Tipo txdAttributes per data
 */
class DateRange extends \Txd\FieldTypes\Date {
    
    use HasDateRangeScope;
    
    public function __construct($nome, $etichetta = "", $classi_html = []){
        parent::__construct($nome,$etichetta, $classi_html);
        $this->tipo_campo = "data";
    }

    public function parse_valore($valore) {
        
        return \carbonStampaData($valore["start"]??null, $this->parse_options)." - ".\carbonStampaData($valore["end"]??null, $this->parse_options);
    }

    public function init_tipo(){
        
        $this->add_classe_html("data_picker");
        $this->set_model_type("date");
    }

    public function tipo_campo_form(){
        return "parse_value";
    }

    public function build_edit(){
        
        return view("txd::FieldTypes.DateRange",["campo_obj"=>$this]);
    }


    

}