<?php
namespace Txd\FieldTypes;

use Closure;
use Txd\Rules\Extensions;

/**
 * Tipo txdAttributes per File
 */
class File extends Text {
    public $isImage = false;

    public function __construct($nome, $etichetta = "", $classi_html = []){
        parent::__construct($nome,$etichetta, $classi_html);
        $this->tipo_campo = "file";
    }

    public function tipo_campo_form(){
        return "file";
    }

    protected ?Extensions $extRule = null;
    public function extensions(string ...$extensions){
        if(!is_null($this->extRule)){
            $this->remove_rule($this->extRule);
        }
        if(count($extensions)>0){
            $this->extRule = new Extensions(...$extensions);
            $this->add_rule($this->extRule);
        }
        return $this;
    }

    public function addExtensions(string ...$extensions){
        if(is_null($this->extRule)){
            return $this->extensions(...$extensions);
        }
        $this->extRule->addExtensions(...$extensions);
        return $this;
    }

    protected $urlBuilder = null;
    public function setUrlBuilder(Closure $urlBuilder){
        $this->urlBuilder = $urlBuilder;
        return $this;
    }

    public function hasUrl(){
        return !is_null($this->urlBuilder);
    }

    public function getUrl(){
        $builder = $this->urlBuilder;
        $url = null;
        if($this->hasUrl()){
            $url = $builder($this->current_model_obj);
        }
        return $url;
    }

    public function optIsImage($value = true){
        $this->isImage = $value;
        return $this;
    }

    public function build_view(){
        if(is_null($this->getUrl())){
            return parent::build_view();
        }
        return view("txd::FieldTypes.File_view", ["campo_obj" => $this]);
        
        
         
        
    }

    public function build_edit(){
        $allowed_extensions = array_map(fn($ext) => ".".$ext,optional($this->extRule)->getExtensions() ?? []);
        return view("txd::FieldTypes.File", ["campo_obj" => $this, "allowed_extensions" => join(",", $allowed_extensions)]);
    }
}