<?php

namespace Txd\Rules;



class Extensions implements \Illuminate\Contracts\Validation\Rule
{
    protected $valid_extensions = [];
    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct(string ...$extensions)
    {
        $this->valid_extensions = $extensions;
    }


    public function addExtensions(string ...$extensions){
        $this->valid_extensions = array_merge($this->valid_extensions ?? [],$extensions);
    }

    public function getExtensions(){
        return $this->valid_extensions ?? [];
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        

            if(!request()->hasFile($attribute)){

                return true;

            }

            $file_extension = strtolower(request()->file($attribute)->getClientOriginalExtension());

            return in_array($file_extension, $this->valid_extensions);
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return trans('txd::fieldtypes.validation.extensions',["ext"=>implode(", ", $this->valid_extensions)]);
    }
}
