<?php

namespace Txd\FieldTypes;

/**
 * Checkbox Star.
 * Se la checkbox è checkata, restituisce la stellina gialla.
 * Altrimenti, quella vuota
 */
class Decimal extends \Txd\FieldTypes\Number
{
    public function __construct($nome, $etichetta = '', $classi_html = [])
    {
        parent::__construct($nome, $etichetta, $classi_html);
        $this->precision(2);
    }

    protected int $precision;

    /**
     * @return this|null
     */
    public function precision(?int $value = null)
    {
        if (is_null($value)) {
            return $this->precision;
        }

        $this->precision = $value;

        $this->set_html_attribute('step', (string) (1 / pow(10, $this->precision)));

        return $this;
    }

    protected int $min;

    /**
     * @return this|null
     */
    public function min(?int $value = null)
    {
        if (is_null($value)) {
            return $this->min;
        }
        $this->min = $value;
        $this->set_html_attribute('min', $this->min);
        $this->add_rule("min:$value");

        return $this;
    }

    protected int $max;

    /**
     * @return this|null
     */
    public function max(?int $value = null)
    {
        if (is_null($value)) {
            return $this->max;
        }
        $this->max = $value;
        $this->set_html_attribute('max', $this->max);
        $this->add_rule("max:$value");

        return $this;
    }

    public static string $global_decimal_separator = ',';

    protected ?string $decimal_separator = null;

    /**
     * @return this|null
     */
    public function decimal_separator(?string $value = null)
    {
        if (is_null($value)) {
            return $this->decimal_separator;
        }
        $this->decimal_separator = $value;

        return $this;
    }

    public static string $global_thousands_separator = '.';

    protected ?string $thousands_separator = null;

    /**
     * @return this|null
     */
    public function thousands_separator(?string $value = null)
    {
        if (is_null($value)) {
            return $this->thousands_separator;
        }
        $this->thousands_separator = $value;

        return $this;
    }

    public function parse_valore($valore)
    {

        return number_format($valore, $this->precision, $this->decimal_separator ?? static::$global_decimal_separator, $this->thousands_separator ?? static::$global_thousands_separator);

    }
}
