<?php

namespace Txd\Console\Commands;

use Illuminate\Console\Command;
use Txd\Utils\ClassFinder;
use Illuminate\Support\Facades\Blade;
use Txd\txdFields;

class FieldTypesHelper extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'ide-helper:field-types';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Generate FieldTypes ide helper ';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->warn("Remember to run composer dumpautoload!");
        $this->info("Searching FieldTypes classes...");
        
        $baseMethods = collect(get_class_methods(txdFields::class))
                    ->filter(fn($el) => \Illuminate\Support\Str::startsWith($el,"add"))
                    ->map(fn($el) => str_replace("add","",$el))
                    ->merge(["CustomMacro","GroupControl","LegacyCheckbox","ParseValue","Radio","SoloTesto","SelectLinked","TxdJson"])
                    ->values();
        
        
        $classFinder = new ClassFinder();
        $builtinClasses =$this->prepareClasses($classFinder->getClassesByNamespace('Txd\\FieldTypes'))->filter(fn($el) => !$baseMethods->contains($el));
        $appClasses = $this->prepareClasses($classFinder->getClassesByNamespace('App\\FieldTypes'))->map(fn($el) => ($baseMethods->contains($el)||$builtinClasses->contains($el))?("App".$el):$el);
        $classes = $appClasses->merge($builtinClasses);
        $classesBlock = "";
        foreach($classes as $class => $shortname){
            $classesBlock .= "     *  @method $class add$shortname(\$nome,\$etichetta = \"\",\$classi_html = [])\n";
        }
                    
$fileContent = '
<?php

namespace Txd{
    /**
     * Txd\txdFields
     *
'.$classesBlock.'
     */
    class txdFields
    {
    }
}

namespace Txd\Facades{
    /**
     * Txd\Facades\DbFields
'.$classesBlock.'
     */
    class DbFields
    {
    }
}
';
        
        file_put_contents(base_path('app/FieldTypes/_types_helper.php'),$fileContent);
        $this->info($classes->count()." classes found. ide helper found at [app/FieldTypes/_types_helper.php]");
        $this->info("");
    }
    
    protected function prepareClasses($classes){
        return collect($classes)
            ->filter(function($el){
                $parts = explode("\\FieldTypes\\",$el);
                return !str_contains($parts[1],"\\");
            })->reduce(function($c,$el){
                $parts = explode("\\FieldTypes\\",$el);
                $c[$el] = $parts[1];
                return $c;
            },collect());
    }
}
