<?php

namespace Txd\FieldTypes;

class VueTag extends Text
{
    public function __construct($nome, $etichetta = '', $classi_html = [])
    {
        parent::__construct($nome, $etichetta, $classi_html);
    }

    public function parse_valore($valore)
    {
        return $valore;
    }

    protected $component_tag = 'div';

    public function componentTag(string $value = null)
    {
        if (is_null($value)) {
            return $this->component_tag;
        }
        $this->component_tag = $value;

        return $this;
    }

    public function setComponentTag(string $value)
    {
        $this->componentTag($value);

        return $this;
    }

    public function build_view()
    {
        $tag = $this->component_tag;
        $value = json_encode($this->get_valore());
        $name = $this->build_nome_campo();
        $attributes = '';
        foreach ($this->html_attributes() as $key => $attr) {
            $attributes .= " $key='".e($attr)."'";
        }

        return "<$tag data-value='$value' data-edit=false data-name='$name' class='{$this->get_classi_html()}' $attributes />";
    }

    public function build_edit()
    {
        $tag = $this->component_tag;
        $value = json_encode($this->get_valore());
        $name = $this->build_nome_campo();
        $attributes = '';
        foreach ($this->html_attributes() as $key => $attr) {
            $attributes .= " $key='".e($attr)."'";
        }

        return "<$tag data-value='$value' data-edit=true data-name='$name' class='{$this->get_classi_html()}' $attributes />";
    }
}
