<?php

namespace Txd\Middleware;

use Closure;
use Exception;

// derivato da \Illuminate\Routing\Middleware\SubstituteBindings
class FormBuildValidation
{
    /**
     * Create a new bindings substitutor.
     *
     * @param  \Illuminate\Contracts\Routing\Registrar  $router
     * @return void
     */
    public function __construct()
    {

    }

    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return mixed
     */
    public function handle($request, Closure $next, ...$parNames)
    {
        $parNames = array_unique($parNames);

        foreach ($parNames as $parName) {

            /** @var \Txd\Traits\txdModel */
            $model = $request->route($parName) ?? null;
            if (is_null($model) || !method_exists($model, 'init_db_fields')) {
                continue;
            }

            $sectors = null;
            $controller = $request->route()->getController();
            // TODO: definire un metodo per disabilitare
            if (!($controller->txd_verification_disabled ?? false)) {
                $token = $request->input('txd_verification');
                $sectors = \Txd\txdFields::getVerificationTokenMatch($token, $request->ajax());
                if (is_null($sectors)) {
                    return $controller->renderer()->error($model, 'FormBuildValidation: no sectors defined');
                    //throw new Exception("FormBuildValidation: no sectors defined");
                }
            }

            $model->init_db_fields($sectors);

        }

        return $next($request);
    }
}
