<?php

namespace Txd\FieldTypes;

/**
 * Tipo txdAttributes per data
 */
class Date extends Datetime
{
    public function __construct($nome, $etichetta = '', $classi_html = [])
    {
        parent::__construct($nome, $etichetta, $classi_html);
        $this->tipo_campo = 'data';
    }

    public function parse_valore($valore)
    {
        $data = $valore;
        if (!is_null($valore)) {
            $data = carbonParse($valore);
            $data->isDatetime(false);
        }

        return carbonStampaData($data, $this->parse_options);
    }

    public function init_tipo()
    {

        $this->add_classe_html('data_picker');
        $this->set_model_type('date');
    }

    public function tipo_campo_form()
    {
        return 'parse_value';
    }
}
