# Txd\txdFields

La classe implementa le interfacce \IteratorAggregate,\ArrayAccess, permettendo l'iterazione in foreach e l'accesso agli attributi tramite indicizzazione come array (\$obj[\$index]).

# API Reference

## Metodi base

### __construct
```php
__construct($current_model_obj = null, $throwaway = false)
```

Costruttore della classe, riceve solo l'istanza del modello a cui associare i campi ($current_model_obj). Può essere caricata successivamente tramite [set_current_model_obj](#setcurrentmodelobj)


### toArray
```php
toArray(string $sector = null) {
```
ritorna il settore passato in input. Se $sector = null ritorna l'intero array interno dei settori.


### current_model_obj
```php
current_model_obj()
```

Ritorna il modello a cui sono attualmente associati i campi

### set_current_model_obj
```php
set_current_model_obj($obj)
```
Associa i campi del txdField corrente al modello $obj.

## Manipolazione dei campi

### add
```php
add($nome,$typeName = "Txd\FieldTypes\Text", $etichetta = "", $classi_html = [])
```
aggiunge un campo al txdFields, associando l'attributo $nome al tipo $typeName.

### remove
```php
remove(string $fieldName,string $sector = "default")
```

elimina il campo $fieldName dal settore $sector. 

### retrieve
```php
retrieve(string $fieldName,string $sector = null)
```

Ritorna l'istanza di txdAttributes relativa al campo selezionato, prendendola dal settore $sector.




### transformFields
```php
transformFields(Closure $callback,$settori = [],$all_sectors = false)
```
permette di applicare una trasformazione a tutti i campi di un txdFields.
$callback deve avere la forma fn(\Txd\txdAttributes $field) => void. se $settori è vuoto la trasformazione viene eseguita solo sul settore default.

## Manipolazione dei settori

### addSector
```php
addSector(string $sector, array|\Closure $sector_definition,bool $add_to_parent_sector = false)
```
permette la definizione di un nuovo settore. L'uso consigliato è passare in $sector_definition un array con i nomi dei campi che si vogliono aggiungere al settore. i campi devono essere già stati definiti. 
é possibile inserire una definizione di un campo nell'array per inserirlo o sostituirlo solo nel settore definito.

La modalità con clousure è una funzione avanzata, l'utilizzo è sconsigliato.

### reduce
```php
reduce($settori = [],$keep = false)
```
Metodo che ritorna una nuova istanza di txdFields, costruita tramite unione dei settori passati in input.
L'unione di tutti i settori sarà il solo settore "default".

se $keep = true, i settori originali vengono ridefiniti a fianco del settore di default.

Se presente, current_model_obj viene propagato sul nuovo oggetto.
### sort
```php
sort(callable $sorting_function = null,string $sector = "default")
```

riordina in place un settore secondo il metodo di ordinamento passato (firma: fn($a,$b) => int). se $sorting_function = null, il settore viene ordinato seocndo il campo $order dei campi.





## Campi per la validazione automatica dei form 

### verification_field
```php
verification_field($settori = null)
```
Crea un campo input html contenente un token univoco che identifica il settore di campi con cui è stato costruito il txdFields corrente. Da questo token, in fase di salvataggio, è possibile ricostruire il txdField (e caricare nei fillable solo i campi selezionati in creazione)


### static_verification_field
```php
static_verification_field($settori = [])
```
Metodo statico equivalente a verification_field



## Metodi Avanzati e interni

### getSectors
```php
getSectors()
```

| Parameter | Type     | Description                |
| :- | :- | :- |
| `api_key` | `string` | descr |



### setSectorAttribute
```php
setSectorAttribute(string $sector, string $key, $value)
```

| Parameter | Type     | Description                |
| :- | :- | :- |
| `api_key` | `string` | descr |


### addField
```php
addField(\Txd\txdAttributes $field, $sectors = [])
```

| Parameter | Type     | Description                |
| :- | :- | :- |
| `$field` | `\Txd\txdAttributes` | descr |
| `$sectors` | `string` | descr |

### getInstance
```php
getInstance()
```

| Parameter | Type     | Description                |
| :- | :- | :- |
| `api_key` | `string` | descr |




### deleteSector
```php
deleteSector(string $sector)
```

| Parameter | Type     | Description                |
| :- | :- | :- |
| `api_key` | `string` | descr |



### editSector
```php
editSector(string $sector, \Closure $sector_definition)
```

| Parameter | Type     | Description                |
| :- | :- | :- |
| `api_key` | `string` | descr |



### cloneSector
```php
cloneSector(string $source,string $new_sector, \Closure $sector_definition = null)
```

| Parameter | Type     | Description                |
| :- | :- | :- |
| `api_key` | `string` | descr |



### mergeSectors
```php
mergeSectors($sources = [],string $new_sector)
```

| Parameter | Type     | Description                |
| :- | :- | :- |
| `api_key` | `string` | descr |



### setSectorAutomaticMerge
```php
setSectorAutomaticMerge(string $sector, bool $enable)
```

| Parameter | Type     | Description                |
| :- | :- | :- |
| `api_key` | `string` | descr |



### addFieldToSectors
```php
addFieldToSectors(\Txd\txdAttributes $field,array $sectors) : void{
```

| Parameter | Type     | Description                |
| :- | :- | :- |
| `api_key` | `string` | descr |



### moveField
```php
moveField(\Txd\txdAttributes $field,string $fieldName,array $sectors = [], bool $before = false) : void {
```

| Parameter | Type     | Description                |
| :- | :- | :- |
| `api_key` | `string` | descr |



### removeFieldFromSectors
```php
removeFieldFromSectors(\Txd\txdAttributes $field,array $sectors,bool $all = false) : void {
```

| Parameter | Type     | Description                |
| :- | :- | :- |
| `api_key` | `string` | descr |



### filter
```php
filter(Closure $callback,$settori = [],$all_sectors = false)
```

| Parameter | Type     | Description                |
| :- | :- | :- |
| `api_key` | `string` | descr |



    
    
### findClass
```php
findClass(string $typeName,array $additionalNamespaces = []): string {
```

| Parameter | Type     | Description                |
| :- | :- | :- |
| `api_key` | `string` | descr |


### getVerificationTokens
```php
getVerificationTokens()
```

| Parameter | Type     | Description                |
| :- | :- | :- |
| `api_key` | `string` | descr |

### getVerificationTokenMatch
```php
getVerificationTokenMatch(?string $token, $keep = false)
```

| Parameter | Type     | Description                |
| :- | :- | :- |
| `api_key` | `string` | descr |

### setVerificationTokens
```php
setVerificationTokens($tokensArray)
```

| Parameter | Type     | Description                |
| :- | :- | :- |
| `api_key` | `string` | descr |
