<?php

namespace Txd\Traits;

/**
 * trait per popolare l'array di $attributes da validare con i valori degli attributi virtuali
 */
trait VirtualAttributesValidationTrait
{
    protected $_getModelAttributes_method = null;

    public function getModelAttributes()
    {
        try {
            if (!is_null($method = $this->_getModelAttributes_method)) {
                $attrs = $this->$method();
            } else {
                $attrs = parent::getModelAttributes();
            }
        } catch (\Throwable $e) {
            $attrs = [];
        }

        $missing_attrs = array_filter(array_keys($this->rules), function ($el) use ($attrs) {
            return !array_key_exists($el, $attrs);
        });

        foreach ($missing_attrs as $attr) {
            if (!is_null($this->$attr)) {
                $attrs[$attr] = $this->$attr;
            }
        }

        return $attrs;
    }
}
