# Txd\txdAttributes

Rappresentazione di un campo, incluse regole di validazione e tipo di input/stampa.

# API Reference

## Metodi base

### __construct
```php
__construct($nome, $tipo = \Txd\FieldTypes\Text::class, $etichetta = "", $classi_html = [])
```

Costruttore del campo. Riceve il nome dell'attributo, il tipo del campop e l'etichetta.

### new
```php
new() : static 
```
Metodo di supporto per definizione inline dei campi. 
```php

$field = new \Txd\txdAttributes("nome_campo","text","etichetta");
// equivalente a 
$field = \Txd\txdAttributes::new("nome_campo","text","etichetta");

//comodo per definizioni complesse inline

$field = (new \Txd\txdAttributes("nome_campo"))->add_rule("required");
// equivalente a
$field = \Txd\txdAttributes::new("nome_campo")->add_rule("required");

```

Il metodo è disponibile per tutti i FiledTypes estesi.


### add_settore
```php
add_settore($nome)
```
Permette di aggiungere il campo corrente ad un settore specifico. é consigliato l'uso del metodo addSector del txdFields relativo.


### add_rule
```php
add_rule($rules)
```

aggiunge una rule al campo. $rules può essere una stringa di rules concatenate con '|', una stringa semplice, un callable o un array di strighe e/o callable

La modalità consigliata è stringa semplice o callable se strettamente necessario

### remove_rule
```php
remove_rule($rules)
```

rimuove le rule dall'attributo. il match deve essere esatto (per eliminare una callable deve essere stata passata con una variabile)

### fillable
```php
fillable($enabled = true)
```

imposta il campo come fillable (o lo disabilita). se $enabled = false, il campo viene impostato come disabled

### isFillable
```php
isFillable()
```
Ritorna lo stato di fillable dell'attributo corrente

### disabled
```php
disabled($enabled = true)
```
imposta il campo come disabled (o lo riabilita)

### isDisabled
```php
isDisabled()
```
Ritorna lo stato di disabled dell'attributo corrente

### get_valore
```php
get_valore($raw = false) 
```
ritorna il valore dell'attributo parsato per la stampa.

### asterisco_manuale
```php
asterisco_manuale($param = true)
```

## Metodi per personalizzazione classi estese

### init_tipo
```php
init_tipo()
```


### parse_valore
```php
parse_valore($valore)
```
Metodo di parsing che trasforma il dato per la  stampa in interfaccia



### tipo_campo_form
```php
tipo_campo_form()
```

### is_mandatory
```php
is_mandatory()
```

### set_order
```php
set_order(int $order)
```

### after
```php
after(string $fieldName, $sectors = [])
```

### before
```php
before(string $fieldName, $sectors = [])
```

### get_errors
```php
get_errors()
```

### has_errors
```php
has_errors()
```


## Metodi di gestione della stampa (render/view/edit)

### get_valore
```php
get_valore($raw = false)
```

### skip_label
```php
skip_label($value = true)
```

### render_view
```php
render_view()
```

### build_view
```php
build_view()
```

### custom_build_view
```php
custom_build_view(\Closure $viewBuilder)
```

### cell
```php
cell(\Closure $cellView)
```

### cellWrap
```php
cellWrap(\Closure $wrapView)
```

### render_edit
```php
render_edit()
```

### build_edit
```php
build_edit()
```

### custom_build_edit
```php
custom_build_edit(callable $viewBuilder)
```

### render_errors
```php
render_errors()
```

### hide_from_edit
```php
hide_from_edit(bool $enable = true)
```

### hide_from_view
```php
hide_from_view(bool $enable = true)
```

### set_build_mode
```php
set_build_mode(int $txd_attribute_build_mode_flag = 0)
```

### field_visibility_classes
```php
field_visibility_classes()
```

### cellProperties
```php
cellProperties() : HtmlProperties 
```

## Metodi di itnerazione html

### add_classe_html
```php
add_classe_html($classe)
```

### remove_classe_html
```php
remove_classe_html($classe)
```

### hasHtmlClass
```php
hasHtmlClass($classe)
```

### add_html_attribute
```php
add_html_attribute($nome, $valore = null)
```

### set_html_attribute
```php
set_html_attribute($nome, $valore = null)
```

### set_placeholder
```php
set_placeholder(string $valore)
```

### remove_html_attribute
```php
remove_html_attribute($nome)
```

### html_attributes
```php
html_attributes()
```

### get_classi_html
```php
get_classi_html() 
```


## Metodi avanzati

### static_parse
```php
static_parse($valore)
```

### clear_rules
```php
clear_rules()
```

### replace_rules
```php
replace_rules($arr_rules = [])
```

### get_model_rules
```php
get_model_rules()
```

### parse_model_rules
```php
parse_model_rules()
```

### build_label_text
```php
build_label_text($raw = false)
```

### set_name_prefix
```php
set_name_prefix(string $prefix)
```

### build_nome_campo
```php
build_nome_campo($prefix=null)
```

### build_nome_input
```php
build_nome_input($prefix=null)
```

### get_nome_campo_sessione
```php
get_nome_campo_sessione() : string 
```

### set_current_model_obj
```php
set_current_model_obj($obj)
```

### set_current_db_fields
```php
set_current_db_fields(\Txd\txdFields $obj)
```

### get_current_db_fields
```php
get_current_db_fields()
```

### get_current_model_obj
```php
get_current_model_obj()
```


### remove_settore
```php
remove_settore($nome)
```

### clear_settori
```php
clear_settori()
```

### set_model_type
```php
set_model_type($tipo)
```

### get_model_type
```php
get_model_type()
```
