<?php

namespace Txd\Traits\Scopes;

use Illuminate\Support\Collection;
use Laravel\SerializableClosure\SerializableClosure;

trait HasScope
{
    protected $query_scope = null;

    protected array $query_scope_params = [];

    public function queryScopeParams()
    {
        return $this->query_scope_params;
    }

    public function addQueryScopeParam($key, $value)
    {
        $pars = $this->queryScopeParams();
        $pars[$key] = $value;
        $this->query_scope_params = $pars;
    }

    public function setQueryScopeParams(array $params)
    {
        $this->query_scope_params = $params;
    }

    public function getScope()
    {
        return $this->scope;
    }

    public function scope($scope, ...$scopeArgs)
    {
        if (is_a($scope, \Closure::class)) {
            $scope = new SerializableClosure($scope);
        }
        $this->query_scope = $scope;
        $this->setQueryScopeParams($scopeArgs);

        return $this;
    }

    /**
     * applica lo scope definito nel campo su $query
     *
     * @param  mixed  $query
     * @return mixed
     */
    public function applyScope($query)
    {
        if (is_a($this->query_scope, SerializableClosure::class)) {
            $query = ($this->query_scope)($query, $this->get_valore(true), ...$this->queryScopeParams());
        } elseif (is_null($this->query_scope)) {
            $query = $this->defaultScope($query, $this->get_valore(true), ...$this->queryScopeParams());
        } else {
            $scope = 'scope'.\Illuminate\Support\Str::studly($this->query_scope);
            if ($scope === 'scopeRicerca' && !method_exists($this->current_db_fields->current_model_obj(), $scope)) {
                $value = $this->get_valore(true);
                $query_scope_params = $this->queryScopeParams();
                $query = defaultScopeRicerca($query, $value, ...$query_scope_params);
            } else {
                $query = call_user_func_array([$this->current_db_fields->current_model_obj(), $scope], array_merge([$query, $this->get_valore(true)], $this->queryScopeParams()));
            }
        }

        return $query;
    }

    /**
     * scope di default: equivalente a ->where([nome_campo],$value)
     *
     * @param  mixed  $query
     * @param  mixed  $value
     * @return mixed
     */
    public function defaultScope($query, $value, ...$scope_params)
    {
        if (!(is_null($value) || $value === "")) {
            return $query->where($this->nome_campo, $value);
        }

        return $query;
    }

    /**
     * @deprecated use defaultScopeRicerca() helper
     * 
     * scope di ricerca testuale. $fields deve contenere i nomi delle colonne in cui cercare
     *
     * @param  mixed  $query
     * @param  mixed  $value
     * @return mixed
     */
    public function defaultScopeRicerca($query, $value, array $fields)
    {
        return defaultScopeRicerca($query,$value,$fields);
    }

    // metodi deprecati

    /**
     * @deprecated
     */
    public function get_query_scope()
    {
        return $this->query_scope ?? null;
    }

    /**
     * @deprecated
     */
    public function set_query_scope($scope)
    {
        $this->query_scope = $scope;
    }

    /**
     * @deprecated
     */
    public function get_query_scope_params()
    {
        return $this->queryScopeParams();
    }

    /**
     * @deprecated
     */
    public function add_query_scope_params($key, $value)
    {
        $this->addQueryScopeParam($key, $value);
    }

    /**
     * @deprecated
     */
    public function replace_query_scope_params(array $params)
    {
        $this->setQueryScopeParams($params);
    }
}
