<?php

namespace Txd\Traits\FieldTypes;



trait LegacyHtmlPropertiesTrait
{
    protected $html_attributes = [];
    protected $classi_html = [];
    public $placeholder = '';
    
    
    /* ------------------------------------------------------------
     * CLASSI HTML
     * ------------------- */

     /**
     * ritorna la stringa con l'elenco delle classi html impostate sul campo in oggetto
     *
     * @internal
     *
     * @return string
     */
    public function get_classi_html()
    {
        return $this->htmlProperties()->renderClasses();
    }
    
    /**
     * aggiunge una (o piu' classi) html all'elenco
     * @deprecated use ->htmlProperties()->addHtmlClass()
     * @param  string|array  $classe nome della classe o array di classi
     * @return $this
     */
    public function add_classe_html($classe)
    {
        $this->htmlProperties()->addHtmlClass($classe);

        return $this;
    }

    /**
     * rimuove la classe html passata dall'elenco
     * @deprecated use ->htmlProperties()->removeHtmlClass()
     * @param  string  $classe
     * @return $this
     */
    public function remove_classe_html($classe)
    {
        $this->htmlProperties()->removeHtmlClass($classe);
        
        return $this;
    }

    /**
     * verifica se l'attributo ha la classe html passata o meno
     * @deprecated retrieve class array with ->htmlProperties()->getHtmlClasses()
     * @param  string  $classe nome della classe
     * @return bool
     */
    public function hasHtmlClass($classe)
    {

        return array_search($classe, $this->classi_html, true) !== false;
    }

    /* ------------------------------------------------------------
     * ATTRIBUTI HTML
     * ------------------- */

    /**
     * Aggiunge un attributo html al campo. Non applica modifiche a campi già esistenti
     * @deprecated use ->htmlProperties()->addHtmlAttribute()
     * @param  string  $nome nome dell'attributo
     * @param  string  $valore valore dell'attributo
     * @return $this
     */
    public function add_html_attribute($nome, $valore = null)
    {
        $this->htmlProperties()->addHtmlAttribute($nome,$valore);
        
        return $this;
    }

    /**
     * Aggiunge o modifica un attributo html sul campo
     * @deprecated use ->htmlProperties()->addHtmlAttribute()
     * @param  string  $nome nome dell'attributo
     * @param  string  $valore valore dell'attributo
     * @return $this
     */
    public function set_html_attribute($nome, $valore = null)
    {
        $this->htmlProperties()->addHtmlAttribute($nome,$valore);
        
        return $this;
    }

    /**
     * Imposta il placeholder del campo
     *
     * @deprecated use ->htmlProperties()->addHtmlAttribute("placeholder",$value)
     * @return $this
     */
    public function set_placeholder(string $valore)
    {
        $this->htmlProperties()->addHtmlAttribute("placeholder",$valore);
        
        return $this;
    }

    /**
     * rimuove l'attributo passato dall'elenco
     * @deprecated use ->htmlProperties()->removeHtmlAttribute()
     * @param  string  $nome
     * @return $this
     */
    public function remove_html_attribute($nome)
    {
        $this->htmlProperties()->removeHtmlAttribute($nome);

        return $this;
    }

    /**
     * restituisce un array con gli attributi html dell'oggetto corrente
     * @deprecated use ->htmlProperties()->getHtmlAttributes()
     * @return array
     */
    public function html_attributes()
    {

        return $this->htmlProperties()->getHtmlAttributes();
    }
    
    
}