<?php

namespace Txd\Traits\FieldTypes;



trait LegacyAttributesTrait
{
    public $valore_fisso = null;
    public $parse_function = '';
    public $obbligatorio = false;
    public $classi_etichetta = [];
    public $is_checked = null;
    public $custom_html = '';
    protected $campo_relazione = null;
    public $tipo_campo = '';
    // Validation
    public $skip_check_fillable = false;
    
    /**
     * permette di impostare l'asterisco per i campi che non lo mostrano in automatico sulla base delle rules
     *
     * @param  bool  $param
     * @return $this
     */
    public function asterisco_manuale($param = true)
    {

        $this->obbligatorio = $param;

        return $this;
    }
    
    /* ------------------------------------------------------------
     * Tipo (per conversione dati nel salvataggio dell'oggetto)
     * ------------------- */
    protected $model_type = null;
    /**
     * imposta un tipo per l'attributo in modo che in fase di salvataggio il valore possa essere convertito
     * opportunamente per il DB
     *
     * @param  string  $tipo float | valuta | date | datetime
     *
     * @internal
     *
     * @return $this
     */
    public function set_model_type($tipo)
    {

        $this->model_type = $tipo;

        return $this;
    }

    /**
     * ritorna il tipo settato per l'attributo in oggetto (o null)
     *
     * @return string|null
     */
    public function get_model_type()
    {

        return $this->model_type;
    }
    
    
    /**
     * Parsing statico del valore secondo il FieldType usato per l'invocazione
     *
     * @param  any  $valore
     *
     * @internal
     *
     * @return any
     */
    public static function static_parse($valore)
    {
        $class = get_called_class();
        $instance = new $class('');

        return $instance->parse_valore($valore);
    }
    
    /* ------------------------------------------------------------
     * FILLABLE
     * ------------------- */
    protected $fillable = true;
    public function fillable(bool $enabled = true)
    {
        $this->fillable = $enabled;
        $this->disabled(!$enabled);
        
        return $this;
    }

    /**
     * @return bool
     */
    public function isFillable()
    {

        return $this->fillable;
    }
    
    /**
     * @return bool
     */
    public function isDisabled()
    {
        return array_key_exists("disabled",$this->htmlProperties()->getHtmlAttributes());
    }
}