<?php

namespace Txd\Traits;

use Illuminate\Support\Facades\Storage;

trait HasFileAttributeTrait
{
    public static function bootHasFileAttributeTrait()
    {
        foreach (static::$fileAttributes ?? [] as $attribute => $props) {
            static::registerModelEvent('validating', function ($model) use ($attribute) {
                if ($model->isFillable($attribute) && request()->hasFile($attribute)) {
                    $file = request()->file($attribute);
                    $props = $model->getFileAttributeProperties($attribute);
                    $model->$attribute = $props['name'] ?? $file->hashName();
                    switch($props["extension"] ?? null){
                        case "server":
                            $model->$attribute = $model->$attribute.".".$file->getExtension();
                            break;
                        case "client":
                            $model->$attribute = $model->$attribute.".".$file->getClientOriginalExtension();
                            break;
                        case null:
                            break;
                        default:
                            $model->$attribute = $model->$attribute.".".$props["extension"];
                            break;
                    }

                    static::registerModelEvent('validated', function ($model, $status) use ($attribute) {
                        if (in_array($status, ['passed', 'skipped'])) {
                            $props = $model->getFileAttributeProperties($attribute);
                            $file = request()->file($attribute);
                            Storage::disk($props['disk'])->putFileAs($props['path'] ?? '', $file, $model->$attribute, $props['options'] ?? null);
                        }
                    });

                }
                static::saved(function ($model) use ($attribute) {
                    if ($model->isDirty($attribute)) {
                        $props = $model->getFileAttributeProperties($attribute);
                        $original = $model->getOriginal($attribute);
                        $path = \Illuminate\Support\Str::finish($props['path'] ?? '', '/');
                        if (!is_null($original) && \Storage::disk($props['disk'])->exists($path.$original)) {
                            \Storage::disk($props['disk'])->delete($path.$original);
                        }
                    }
                });
            });
        }
    }

    public function getFileAttributeProperties($attribute): array
    {
        $props = static::$fileAttributes[$attribute] ?? [];
        if (is_callable($props)) {
            return $props($this);
        }

        return $props;
    }
}
