<?php

namespace Txd\FieldTypes;

/**
 * Tipo txdAttributes per textarea
 */
class Textarea extends \Txd\txdAttributes
{
    public function __construct($nome, $etichetta = '', $classi_html = [])
    {
        parent::__construct($nome, $etichetta, $classi_html);
        $this->htmlProperties()->addHtmlAttribute('rows', 5);
    }

    public function parse_valore($valore)
    {

        return $valore;
    }

    public function tipo_campo_form()
    {
        return 'textarea';
    }

    public function build_view()
    {

        return $this->get_valore();
    }

    public function build_edit()
    {

        return view('txd::FieldTypes.Textarea', ['campo_obj' => $this]);
    }
}
