<?php

use Txd\HtmlProperties;

test('add one class', function () {
    $props = new HtmlProperties();

    $props->addHtmlClass('class1');
    expect($props->renderHtmlProperties())->toBe("class='class1'");
});

test('add multiple classes', function () {
    $props = new HtmlProperties();

    $props->addHtmlClass(['class1', 'class2']);
    $props->addHtmlClass(['class3', 'class4']);
    expect($props->renderHtmlProperties())->toBe("class='class1 class2 class3 class4'");
});

test('add one style', function () {
    $props = new HtmlProperties();

    $props->addHtmlStyle('style1', 'value1');
    expect($props->renderHtmlProperties())->toBe("style='style1: value1'");
});

test('add multiple styles', function () {
    $props = new HtmlProperties();

    $props->addHtmlStyle('style1', 'value1');
    $props->addHtmlStyle('style2', 'value2');
    expect($props->renderHtmlProperties())->toBe("style='style1: value1; style2: value2'");

});

test('add id', function () {
    $props = new HtmlProperties();

    $props->setHtmlId('myId');
    expect($props->renderHtmlProperties())->toBe("id='myId'");
});

test('add one attribute', function () {
    $props = new HtmlProperties();

    $props->addHtmlAttribute('attr1', 'value1');
    expect($props->renderHtmlProperties())->toBe("attr1='value1'");
});

test('add multiple attributes', function () {
    $props = new HtmlProperties();

    $props->addHtmlAttribute('attr1', 'value1');
    $props->addHtmlAttribute('attr2', 'value2');
    expect($props->renderHtmlProperties())->toBe("attr1='value1' attr2='value2'");
});
