<?php

namespace Txd\FieldTypes;

class ExtraSelect extends \Txd\FieldTypes\Select
{
    protected $identifier;

    public function __construct($nome, $etichetta = '', $classi_html = [])
    {
        parent::__construct($nome, $etichetta, $classi_html);
        $this->htmlProperties()->addHtmlClass('extraselect');
        $this->htmlProperties()->addHtmlAttribute('data-dropdown-container', '.modal-body');
    }

    /**
     * Metodo per abilitare il caricamento del Select tramite ajax e supporto per abilitare la ricerca in ajax.
     * La Closure deve ritornare un array di oggetti nella forma ["key"=>'chiave',"value" => 'value'].
     * Per supportare la ricerca la closure deve poter ricevere 2 parametri:
     * $search come stringa, chiave di ricerca
     * $key, per la raccolta di elementi singoli con match esatto della chiave
     *
     * per la definizione della closure si può usare l'helper optionSelectSearch()
     *
     * @param  mixed  $urlOrClosure
     * @param  bool  $searchable
     * @return $this
     */
    public function optLoadFromAjax($urlOrClosure, $searchable = false)
    {
        if (is_callable($urlOrClosure)) {
            $identifier = static::searchMethodPut($urlOrClosure);
            $this->identifier = $identifier;
            $url = route('extraselect.search', ['identifier' => $identifier]);
        } else {
            $url = $urlOrClosure;
        }

        $this->htmlProperties()->addHtmlAttribute('data-url', $url);
        $this->htmlProperties()->addHtmlAttribute('data-searchable-url', $searchable);
        $this->htmlProperties()->addHtmlAttribute('data-fetch-options', json_encode(['body' => ['_token' => csrf_token()]]));

        return $this;
    }

    public function build_edit(){
        $this->setStartingValues();
        return parent::build_edit();
    }

    public function build_view()
    {
        $this->setStartingValues();
        return parent::build_view();
    }

    protected function setStartingValues(){
        $serializedCallback = session()->get("extraselect.$this->identifier");
        $callback = $serializedCallback?->getClosure();
        if(!is_callable($callback)){
            return;
        }
        $StartingElement = $callback(null, $this->get_valore(true));
        $startingValue = [];
        if (count($StartingElement) > 0) {
            foreach ($StartingElement as $element) {
                $startingValue[$element['key']] = $element['value'];
            }
        }
        $this->opzioni_select($startingValue);
    }

    public function optSearch($enable = true, $minChars = 0)
    {
        $this->htmlProperties()->addHtmlAttribute('data-search', $enable);
        $this->htmlProperties()->addHtmlAttribute('data-min-chars', $minChars);

        return $this;
    }

    public static function searchMethodPut($callback, string $identifier = null)
    {
        $serializable = new \Laravel\SerializableClosure\Serializers\Native($callback);
        if (is_null($identifier)) {
            $code = $serializable->getReflector()->getCode();
            $variables = $serializable->getReflector()->getUseVariables();
            $identifier = md5(json_encode(['code' => $code, 'variables' => $variables]));
        }
        session()->put("extraselect.$identifier", $serializable);

        return $identifier;
    }

    public static function searchMethodGet(string $identifier, $searchTerm)
    {
        $serializedCallback = session()->get("extraselect.$identifier");
        $callback = $serializedCallback?->getClosure();
        if (is_callable($callback)) {
            return $callback($searchTerm);
        }

        return [];
    }
}
