<?php

// idea and basic implementation taken from Laravel's Macroable trait (https://github.com/laravel/framework/blob/8.x/src/Illuminate/Macroable/Traits/Macroable.php)

namespace Txd\Traits;

use BadMethodCallException;
use Closure;
use ReflectionClass;
use ReflectionMethod;

/**
 * @deprecated non più supportato, se fosse necessario usare il trait Macroable di Laravel
 */
trait Extendable
{
    /**
     * The registered string macros.
     *
     * @var array
     */
    protected static $extensions = [];

    /**
     * Register a custom macro.
     *
     * @param  string  $name
     * @param  object|callable  $extension
     * @return void
     */
    public static function extend($name, $extension)
    {
        if (!array_key_exists($name, static::$extensions)) {
            static::$extensions[$name] = [];
        }
        static::$extensions[$name][static::class] = $extension;
    }

    /**
     * Mix another object into the class.
     *
     * @param  object  $mixin
     * @param  bool  $replace
     * @return void
     *
     * @throws \ReflectionException
     */
    public static function extendWith($mixin, $replace = true)
    {
        $methods = (new ReflectionClass($mixin))->getMethods(
            ReflectionMethod::IS_PUBLIC | ReflectionMethod::IS_PROTECTED
        );

        foreach ($methods as $method) {
            if ($replace || !static::hasExtension($method->name)) {
                $method->setAccessible(true);
                static::extend($method->name, $method->invoke($mixin));
            }
        }
    }

    /**
     * Checks if macro is registered.
     *
     * @param  string  $name
     * @return bool
     */
    public static function hasExtension($name)
    {
        if (!array_key_exists($name, static::$extensions)) {
            return false;
        }

        foreach (array_reverse(static::$extensions[$name]) as $class => $value) {
            if (is_a(static::class, $class, true)) {
                return true;
            }
        }

        return false;
    }

    public static function getExtensions()
    {
        return static::$extensions;
    }

    public static function flushExtensions()
    {
        static::$extensions = [];
    }

    /**
     * Dynamically handle calls to the class.
     *
     * @param  string  $method
     * @param  array  $parameters
     * @return mixed
     *
     * @throws \BadMethodCallException
     */
    public static function __callStatic($method, $parameters)
    {
        if (!static::hasExtension($method)) {
            throw new BadMethodCallException(sprintf(
                'Method %s::%s does not exist.', static::class, $method
            ));
        }
        $value = null;
        foreach (array_reverse(static::$extensions[$method]) as $class => $v) {
            if (is_a(static::class, $class, true)) {
                $value = $v;
                break;
            }
        }
        $extension = $value;

        if ($extension instanceof Closure) {
            $extension = $extension->bindTo(null, static::class);
        }

        return $extension(...$parameters);
    }

    protected $call_extension_as = null;

    /**
     * Overrides the class used to search the extension method. Needed to call parent extended methods
     *
     * @return $this
     */
    public function call_extension_as(string $class)
    {
        $this->call_extension_as = $class;

        return $this;
    }

    /**
     * Dynamically handle calls to the class.
     *
     * @param  string  $method
     * @param  array  $parameters
     * @return mixed
     *
     * @throws \BadMethodCallException
     */
    public function __call($method, $parameters)
    {
        $current_class = $this->call_extension_as ?? static::class;

        if (!$current_class::hasExtension($method)) {
            throw new BadMethodCallException(sprintf(
                'Method %s::%s does not exist.', $current_class, $method
            ));
        }
        $value = null;
        foreach (array_reverse($current_class::$extensions[$method]) as $class => $v) {
            if (is_a($current_class, $class, true)) {
                $value = $v;
                break;
            }
        }
        $extension = $value;

        if ($extension instanceof Closure) {
            $extension = $extension->bindTo($this, $current_class);
        }

        $out = $extension(...$parameters);
        // after executing the extended method, reset the call_extension_as attribute tu null, so other extended methods called after this will have the correct behaviour
        $this->call_extension_as = null;

        return $out;
    }
}
