<?php

namespace Txd\Console\Commands;

use Illuminate\Console\Command;

class PublishLegacy extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'txd:legacy';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'publish the overrides for legacy txdAttributes support';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        
        $this->info('Publishing legacy override...');
        if (!is_dir(base_path('Legacy'))) {
            mkdir(base_path('Legacy'));
        }
        
        if(file_exists(base_path('Legacy/txdAttributes.php'))){
            $this->error(base_path('Legacy/txdAttributes.php')." already exist!");
        }else{    
            $fileContent = file_get_contents(__DIR__.'/../../stubs/txdAttributes.stub');
            file_put_contents(base_path('Legacy/txdAttributes.php'), $fileContent);
        }
        if(file_exists(base_path('Legacy/Traits/txdModel.php'))){
            $this->error(base_path('Legacy/Traits/txdModel.php')." already exist!");
        }else{   
            if (!is_dir(base_path('Legacy/Traits'))) {
                mkdir(base_path('Legacy/Traits'));
            } 
            $fileContent = file_get_contents(__DIR__.'/../../stubs/txdModelTrait.stub');
            file_put_contents(base_path('Legacy/Traits/txdModel.php'), $fileContent);
        }
        $this->info("Adding Legacy Autoload...");
        
        $composerJson = json_decode(file_get_contents(base_path('composer.json')),true);
        
        if(!array_key_exists("autoload",$composerJson)){
            $composerJson["autoload"] = [];
        }
        if(!array_key_exists("psr-4",$composerJson["autoload"])){
            $composerJson["autoload"]["psr-4"] = [];
        }
        if(!array_key_exists("Txd\\",$composerJson["autoload"]["psr-4"])){
            $composerJson["autoload"]["psr-4"]["Txd\\"] = "Legacy/";
            file_put_contents(base_path('composer.json'),json_encode($composerJson,JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES));
        }else{
            $this->error("The Txd namespace is already replaced!");
        }
        
        $this->info('Done!');
        $this->warn('Remember to run: composer dumpautoload');
        return 0;
    }
}
