<?php

namespace Txd\FieldTypes;

class VueTag extends Text
{
    public function __construct($nome, $etichetta = '', $classi_html = [])
    {
        parent::__construct($nome, $etichetta, $classi_html);
    }

    public function parse_valore($valore)
    {
        return $valore;
    }

    protected $component_tag = 'div';

    public function componentTag(string $value = null)
    {
        if (is_null($value)) {
            return $this->component_tag;
        }
        $this->component_tag = $value;

        return $this;
    }

    public function setComponentTag(string $value)
    {
        $this->componentTag($value);

        return $this;
    }
    
    /**
     * Helper per l'aggiunta di contesto data-* al componente vue. Equivale a ->htmlProperties()->addHtmlAttribute("data-[$key]",$value)
     * @param string $key 
     * @param mixed $value 
     * @return $this 
     */
    public function optData(string $key, $value){
        $this->htmlProperties()->addHtmlAttribute("data-".\Illuminate\Support\Str::kebab($key),$value);
        return $this;
    }

    public function build_view()
    {
        $tag = $this->component_tag;
        $value = e(json_encode($this->get_valore()));
        $name = e($this->build_nome_campo());
        
        

        return "<$tag data-value='$value' data-edit=false data-name='$name' {$this->htmlProperties()->renderHtmlProperties()} ></$tag>";
    }

    public function build_edit()
    {
        $tag = $this->component_tag;
        $value = e(json_encode($this->get_valore()));
        $name = e($this->build_nome_campo());
        

        return "<$tag data-value='$value' data-edit=true data-name='$name' {$this->htmlProperties()->renderHtmlProperties()} ></$tag>";
    }
}
