<?php

namespace Txd\FieldTypes;

class Actions extends StaticHtml
{
    public function __construct($nome, $etichetta = '', $classi_html = [])
    {
        parent::__construct($nome, $etichetta, $classi_html);
        $this->htmlProperties()->addHtmlClass(['d-flex', 'gap-xs', 'justify-content-end']);
    }

    public $buttons = [];

    public function add_action(string $key, callable $function)
    {
        $this->buttons[$key] = $function;

        return $this;
    }

    public function add_actions(array $functions)
    {
        $this->buttons = array_merge($this->buttons, $functions);

        return $this;
    }

    public function remove_action(string $key)
    {
        unset($this->buttons[$key]);

        return $this;
    }

    public function build_view()
    {
        return "<div class='{$this->htmlProperties()->renderClasses()}'>".implode('', array_map(fn ($el) => $el($this->current_db_fields->current_model_obj()), $this->buttons)).'</div>';
    }

    public function build_edit()
    {
        return '';
    }
}
