<?php

namespace Txd\Traits\Scopes;

use Illuminate\Support\Carbon;
use Illuminate\Support\Collection;

trait HasDateRangeScope
{
    public function scope_start_column(string $name)
    {
        if (count($this->queryScopeParams()) === 0) {
            $this->setQueryScopeParams([null, null]);
        }
        $this->addQueryScopeParam(0, $name);

        return $this;
    }

    public function scope_end_column(string $name)
    {
        if (count($this->queryScopeParams()) === 0) {
            $this->setQueryScopeParams([null, null]);
        }
        $this->addQueryScopeParam(1, $name);

        return $this;
    }

    public function defaultScope($query, $value, ...$scope_params)
    {
        $start_date_column = ($scope_params[0] ?? $this->nome_campo) ?? null;
        $end_date_column = $scope_params[1] ?? $start_date_column;

        if (is_array($value)) {
            $parsedStart = $value['start'] ? Carbon::parse($value['start'])->startOfDay() : null;
            $parsedEnd = $value['end'] ? Carbon::parse($value['end'])->endOfDay() : null;

            if ($parsedStart) {
                if (is_a($query, Collection::class)) {
                    $query = $query->filter(fn ($el) => Carbon::parse($el->$end_date_column) >= $parsedStart);
                } else {
                    $query->where($end_date_column, '>=', $parsedStart->format('Y-m-d H:i:s'));
                }
            }
            if ($parsedEnd) {
                if (is_a($query, Collection::class)) {
                    $query = $query->filter(fn ($el) => Carbon::parse($el->$start_date_column) <= $parsedEnd);
                } else {
                    $query->where($start_date_column, '<=', $parsedEnd->format('Y-m-d H:i:s'));
                }
            }
        }

        return $query;
    }
}
