<?php

namespace Txd\Middleware;

use Closure;
use Exception;
use Str;

// derivato da \Illuminate\Routing\Middleware\SubstituteBindings
class FormBuildValidation
{
    protected static ?array $validatedSectors = null;

    public static function validatedSectors()
    {
        return static::$validatedSectors;
    }

    /**
     * Create a new bindings substitutor.
     *
     * @param  \Illuminate\Contracts\Routing\Registrar  $router
     * @return void
     */
    public function __construct() {}

    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return mixed
     */
    public function handle($request, Closure $next, ...$parNames)
    {

        $controller = $request->route()->getController();
        // TODO: definire un metodo per disabilitare
        if (!($controller->txd_verification_disabled ?? false)) {
            $sectors = null;
            $model = null;
            $parNames = array_unique(array_merge($parNames, array_map(fn ($str) => Str::snake($str), $parNames)));
            foreach ($parNames as $parName) {
                /** @var \Txd\Traits\txdModel */
                $loopModel = $request->route($parName) ?? null;
                if (!is_null($loopModel) && method_exists($loopModel, 'init_db_fields')) {
                    $model = $loopModel;
                    break;
                }
            }

            $token = $request->input('txd_verification');
            $sectors = \Txd\txdFields::getVerificationTokenMatch($token, $request->ajax());

            if (is_null($sectors)) {
                return $controller->renderer()->error($model, 'FormBuildValidation: no sectors defined');
                //throw new Exception("FormBuildValidation: no sectors defined");
            }
            static::$validatedSectors = $sectors;
            if (!is_null($model)) {
                $model->init_db_fields($sectors);
            }
        }

        return $next($request);
    }
}
